'use client';

import GuestGuard from '@/contexts/auth/guard/guest-guard';
import AuthClassicLayout from '@/layouts/auth/classic';
import CompactLayout from '@/layouts/compact';
import { SnackbarProvider } from 'notistack';

// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

export default function Layout({ children }: Props) {
  return <SnackbarProvider
    maxSnack={3}
    anchorOrigin={{ vertical: 'top', horizontal: 'right' }}
  >
    <CompactLayout>{children}</CompactLayout>
  </SnackbarProvider>

}