import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Formulaire Candidat - VSN Transport',
  description: 'Formulaire de candidature pour VSN Transport',
  robots: 'noindex,nofollow', // Prevent search engine indexing
};

export default function CandidateFormLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="fr">
      <body style={{ margin: 0, fontFamily: 'Roboto, Arial, sans-serif' }}>
        {children}
      </body>
    </html>
  );
}
