import { paths } from '@/routes/paths';
import { getRuntimeConfig } from '@/services/config';



// ROOT PATH AFTER LOGIN SUCCESSFUL
export const PATH_AFTER_LOGIN = paths.dashboard.exploitation.root

// Get API gateway URL from runtime config
export const getGatewayApiUrl = async () => {
  const config = await getRuntimeConfig();
  return config.vsnGatewayApiUrl;
};

// Document service configuration
export const DOCUMENT_SERVICE_BASE_URL = process.env.NEXT_PUBLIC_DOCUMENT_SERVICE_BASE_URL || "https://vsn-rec.s3.eu-west-3.amazonaws.com/document_service_folder";

