import { useState, useCallback } from 'react';

 interface FilterRow {
    id: string;
    attribute: string;
    condition: string;
    value: string;
  }
export const useTableFilter = () => {
  const [localFilters, setLocalFilters] = useState<FilterRow[]>([
    { id: '1', attribute: '', condition: '', value: '' },
  ]);

  const addFilter = useCallback(() => {
    const newFilter = {
      id: Math.random().toString(36).substr(2, 9),
      attribute: '',
      condition: '',
      value: '',
    };
    setLocalFilters((prev) => [...prev, newFilter]);
  }, []);

  const removeFilter = useCallback((id: string) => {
    setLocalFilters((prev) => prev.filter((filter) => filter.id !== id));
  }, []);

  const updateFilter = useCallback((id: string, field: keyof FilterRow, value: string | boolean | Date | null) => {
    setLocalFilters((prev) =>
      prev.map((filter) => (filter.id === id ? { ...filter, [field]: value } : filter))
    );
  }, []);

  const clearFilters = useCallback(() => {
    setLocalFilters([{ id: '1', attribute: '', condition: '', value: '' }]);
  }, []);

  return {
    localFilters,
    addFilter,
    removeFilter,
    updateFilter,
    clearFilters,
  };
};

