import { paths } from '@/routes/paths';
import SvgColor from '@/shared/components/svg-color';
import { Menu } from '@/utils/enumeration';
import { usePathname } from 'next/navigation';
import { useEffect, useMemo, useState } from 'react';
import { MenuItem } from './types';

const icon = (name: string, width: number = 40) => (
  <SvgColor src={`/assets/icons/menu/${name}.svg`} sx={{ width, height: width }} />
);

const ICONS = (width: number) => ({
  exploitation: icon('ic_exploitation', width),
  configAdmin: icon('ic_config_admin', width),
  facturationPaiement: icon('ic_facturation_paiement', width),
  flottes: icon('ic_flottes', width),
  geolocalisation: icon('ic_geolocalisation', width),
  appelOffre: icon('ic_appel_offre', width),
  planning: icon('ic_planning', width),
  rh: icon('ic_rh', width),
  staff: icon('ic_staff', width),
});


export function useNavData(width: number) {
  const currentPath = usePathname();
  const icons = ICONS(width);

  const [activeMenu, setActiveMenu] = useState<string>(() => {
    if (currentPath.startsWith(paths.dashboard.exploitation.root)) return Menu.Exploitation;
    if (currentPath.startsWith(paths.dashboard.configAdmin.root)) return Menu.ConfigAdmin;
    if (currentPath.startsWith(paths.dashboard.facturationPaiement.root)) return Menu.FacturationPaiement;
    if (currentPath.startsWith(paths.dashboard.flottes.root)) return Menu.Flottes;
    if (currentPath.startsWith(paths.dashboard.geolocalisation.root)) return Menu.Geolocalisation;
    if (currentPath.startsWith(paths.dashboard.appelOffre.root)) return Menu.AppelOffre;
    if (currentPath.startsWith(paths.dashboard.planning.root)) return Menu.Planning;
    if (currentPath.startsWith(paths.dashboard.rh.root)) return Menu.Rh;
    if (currentPath.startsWith(paths.dashboard.staff.root)) return Menu.Staff;
    if (currentPath.startsWith(paths.dashboard.flottes.consumption.root)) return Menu.Flottes; 
    return Menu.Exploitation;
  });

  useEffect(() => {
    const getActiveMenu = (() => {
      if (currentPath.startsWith(paths.dashboard.exploitation.root)) return Menu.Exploitation;
      if (currentPath.startsWith(paths.dashboard.configAdmin.root)) return Menu.ConfigAdmin;
      if (currentPath.startsWith(paths.dashboard.facturationPaiement.root)) return Menu.FacturationPaiement;
      if (currentPath.startsWith(paths.dashboard.flottes.root)) return Menu.Flottes;
      if (currentPath.startsWith(paths.dashboard.geolocalisation.root)) return Menu.Geolocalisation;
      if (currentPath.startsWith(paths.dashboard.appelOffre.root)) return Menu.AppelOffre;
      if (currentPath.startsWith(paths.dashboard.planning.root)) return Menu.Planning;
      if (currentPath.startsWith(paths.dashboard.rh.root)) return Menu.Rh;
      if (currentPath.startsWith(paths.dashboard.staff.root)) return Menu.Staff;
      return Menu.Exploitation;
    })();
    setActiveMenu(getActiveMenu);
  }, [currentPath]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const menuItems: Record<string, MenuItem> = {
    exploitation: {
      title: 'Exploitation',
      path: paths.dashboard.exploitation.root,
      icon: icons.exploitation,
      children: [
        {
          title: 'Circuit / Usager',
          path: paths.dashboard.exploitation.circuitUsager.root,
          children: [
            { title: 'Usager', path: paths.dashboard.exploitation.circuitUsager.usager },
            { title: 'Circuit', path: paths.dashboard.exploitation.circuitUsager.circuit },
            { title: 'Trajet', path: paths.dashboard.exploitation.circuitUsager.trajet },
            { title: 'Avenant', path: paths.dashboard.exploitation.circuitUsager.avenant },
            { title: 'Absence', path: paths.dashboard.exploitation.circuitUsager.absence },
          ],
        },
        {
          title: 'Contrat',
          path: paths.dashboard.exploitation.contract,
        },
        {
          title: 'Client',
          path: paths.dashboard.exploitation.client,
        },
        {
          title: 'Etablissement',
          path: paths.dashboard.exploitation.establishment.root,
          children: [
            {
              title: 'Liste Établissement',
              path: paths.dashboard.exploitation.establishment.liste,
            },
            {
              title: 'Vacance / Jour Férié',
              path: paths.dashboard.exploitation.establishment.holiday,
            },
            {
              title: 'Feuille de Présence',
              path: paths.dashboard.exploitation.establishment.feuillePresence,
            },
          ],
        },
        { title: 'Infrastructure', path: paths.dashboard.exploitation.infrastructure },
        {
          title: 'Chauffeur',
          path: paths.dashboard.exploitation.chauffeur.root,
          children: [
            { title: 'Liste chauffeur', path: paths.dashboard.exploitation.chauffeur.liste },
            {
              title: 'Planning chauffeur',
              path: paths.dashboard.exploitation.chauffeur.planning,
            },
            {
              title: 'Feuille de route',
              path: paths.dashboard.exploitation.chauffeur.feuilleRoute,
               children: [
            { title: 'Liste Feuille de route',
               path: paths.dashboard.exploitation.chauffeur.feuilleRoute, 
            },
            {
              title: 'Envoi Feuille de route',
              path: paths.dashboard.exploitation.chauffeur.envoiFeuilleRoute,
            },
            {
              title: 'Feuille de route soumise',
              path: paths.dashboard.exploitation.chauffeur.submittedRoadMap,
            }],
          },
            { title: 'Suivi trajet', path: paths.dashboard.exploitation.chauffeur.suiviTrajet },
            { title: 'Absence', path: paths.dashboard.exploitation.chauffeur.absence },
          ],
        },
        {
          title: 'Préparation',
          path: paths.dashboard.exploitation.preparation.root,
          children: [
            {
              title: 'Préparation Usager',
              path: paths.dashboard.exploitation.preparation.usager,
            },
            {
              title: 'Préparation Circuit',
              path: paths.dashboard.exploitation.preparation.circuit,
            },
            {
              title: 'Préparation Chauffeur',
              path: paths.dashboard.exploitation.preparation.chauffeur,
            },
          ],
        },
      ],
    },
    flottes: {
      title: 'Flottes',
      path: paths.dashboard.flottes.root,
      icon: icons.flottes,
      children: [
        { title: 'Location de voiture', path: paths.dashboard.flottes.location },
        {
          title: 'Véhicule', path: paths.dashboard.flottes.vehicle.root,
          children: [
            {
              title: 'Parc Véhicule',
              path: paths.dashboard.flottes.vehicle.park,
            },
            { title: 'Marques / Modéles', path: paths.dashboard.flottes.vehicle.brands },
            { title: 'Suivi Kilométrage', path: paths.dashboard.flottes.vehicle.mileage },         
          ]
        },
        {
          title: 'Carburant', path: paths.dashboard.flottes.consumption.root,
          children: [
            { title: 'Pétrolier', path: paths.dashboard.flottes.consumption.tanker },
            { title: 'Suivi de carte', path: paths.dashboard.flottes.consumption.suiviCartes},
            { title: 'Frais carburant', path: paths.dashboard.flottes.consumption.fees},
            { title: 'Suivi Carburant', path: paths.dashboard.flottes.consumption.fuel },
          ]
        },
        { title: 'Attribution / restitution', path: paths.dashboard.flottes.assignment },
        { title: 'Anomalie traitée', path: paths.dashboard.flottes.anomaly },
        { title: 'Configuration des Anomalies', path: paths.dashboard.flottes.configAnomaly },
        { title: 'bilan carbone', path: paths.dashboard.flottes.carbonReport },
        {
          title: 'Fournisseur', path: paths.dashboard.flottes.supplier.root,
          children: [
            { title: 'Liste fournisseur', path: paths.dashboard.flottes.supplier.supplierTypes },
          ]
        },
        { title: 'Revision et Entretien', path: paths.dashboard.flottes.revision },
        { title: 'Réparation', path: paths.dashboard.flottes.maintenance.root,
          children: [
            { title: 'Liste réparation', path: paths.dashboard.flottes.maintenance.repair },
          ]
         },
        { title: 'Accident / Sinistres', path: paths.dashboard.flottes.incidents },
        { title: 'Document de flotte', path: paths.dashboard.flottes.document },
      ],
    },
    rh: {
      title: 'RH',
      path: paths.dashboard.rh.root,
      icon: icons.rh,
      children: [
        {
          title: 'Recrutement',
          path: paths.dashboard.rh.embauche.root,
          children: [
            { title: 'Candidature chauffeur', path: paths.dashboard.rh.embauche.candidatures },
            { title: 'Candidature sédentaire', path: paths.dashboard.rh.embauche.candidaturesSedentaire },
            { title: 'Besoins Recrutement', path: paths.dashboard.rh.embauche.besoinsRecrutement },
            { title: 'Formulaires', path: paths.dashboard.rh.embauche.formulaire },
          ]
        },
        { title: 'Salariés', path: paths.dashboard.rh.salarié },
        { title: 'Calendrier', path: paths.dashboard.rh.calendar },
        { title: 'RDV annuel', path: paths.dashboard.rh.rdvAnnuel },
        { title: 'Absence Congé', path: paths.dashboard.rh.absence },
        { title: 'Document', path: paths.dashboard.rh.document },
      ],
    },
    facturation_paiement: {
      title: 'Facturation et Paiement',
      path: paths.dashboard.facturationPaiement.root,
      icon: icons.facturationPaiement,
    },
    geolocalisation: {
      title: 'Géolocalisation',
      path: paths.dashboard.geolocalisation.root,
      icon: icons.geolocalisation,
       children: [
        { title: 'Suivi réel des véhicules', path: paths.dashboard.geolocalisation.root },
        { title: 'Historique Géolocalisation', path: paths.dashboard.geolocalisation.history },
      ],
    },
    planning: {
      title: 'Planning',
      path: paths.dashboard.planning.root,
      icon: icons.planning,
      children: [
        { title: 'Planning Véhicule', path: paths.dashboard.planning.vehicule },
        { title: 'Planning Chauffeur', path: paths.dashboard.planning.chauffeur },
        { title: 'Planning de Location', path: paths.dashboard.planning.location },
      ],
    },
    config_admin: {
      title: 'Configuration / Administration',
      path: paths.dashboard.configAdmin.root,
      icon: icons.configAdmin,
      children: [
        { title: 'Agent et Rôle', path: paths.dashboard.configAdmin.agentRole },
        { title: 'Gestion Email', path: paths.dashboard.configAdmin.email },
        { title: 'Gestion Notifications', path: paths.dashboard.configAdmin.notification },
      ],
    },
    appel_offre: {
      title: "Appel d'offre",
      path: paths.dashboard.appelOffre.root,
      icon: icons.appelOffre,
    },
    staff: {
      title: 'Staff',
      path: paths.dashboard.staff.root,
      icon: icons.staff,
      children: [
        {
          title: 'Gestion d\'absences/congé',
          path: paths.dashboard.staff.absence,
        },
        {
          title: 'Gestion des documents',
          path: paths.dashboard.staff.document,
        },
        {
          title: 'Profil utilisateur',
          path: paths.dashboard.staff.profil,
          children: [
            {
              title: 'Mon profil',
              path: paths.dashboard.staff.profilDetails
            },
            {
              title: 'Status de travail',
              path: paths.dashboard.staff.profilStatus
            },
            {
              title: 'Notifications',
              path: paths.dashboard.staff.profilNotifications
            },
            {
              title: 'Langues et région',
              path: paths.dashboard.staff.profilLanguesAndRegion
            },
            {
              title: 'Mot de passe',
              path: paths.dashboard.staff.profilpassword
            },
            {
              title: 'Historique de session',
              path: paths.dashboard.staff.profilsessionHistorique
            },
          ]
        },
        {
          title: 'Historiques Des Emails',
          path: paths.dashboard.staff.email,
        },
      ]
    },
  };

  const navData = useMemo(() => {
    return menuItems[activeMenu];
  }, [activeMenu, menuItems]);

  const rootMenuList = useMemo(() => {
    return Object.keys(menuItems).map((key) => ({
      title: menuItems[key].title,
      path: menuItems[key].path,
      icon: menuItems[key].icon,
    }));
  }, [menuItems]);

  return { navData, rootMenuList };
}

