'use client';

import { Box, BoxProps } from '@mui/system';
import { ScrollBox, tabsBorder } from '@/shared/theme/css';
import { LocalizationProvider } from '@mui/x-date-pickers';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { fr } from 'date-fns/locale';
import { Typography } from '@mui/material';
import { pxToRem } from '@/shared/theme/typography';

interface CustomProps {
  children: React.ReactNode;
  titre?: string | React.ReactNode;
  isSousElemnt?:boolean;  
  hasBorder?:boolean;  
}
export type FormContainerProps = BoxProps & CustomProps;


export default function FormContainer({ children,isSousElemnt, titre, sx, hasBorder }: FormContainerProps) {
  return (
    <LocalizationProvider dateAdapter={AdapterDateFns} adapterLocale={fr}>
      <ScrollBox
        sx={{
          display: 'flex',
          flexDirection: 'column',
          height: '100%',
          mb: '15px',
          width: '100%',
          overflow: 'auto',
          position: 'relative',
        }}
      >
        <Box
          sx={{
            display: 'flex',
            flexDirection: 'column',
            flexGrow: 1,
            backgroundColor: 'white',
            borderBottomRightRadius: '10px',
            borderBottomLeftRadius: '10px',
            borderTopRightRadius: '10px',
            ...(hasBorder && tabsBorder),
            ...sx,
          }}
          pb={isSousElemnt ? 0 : 2}
          pt={2}
          px={isSousElemnt ? 0 : 6}
        >
          {titre ? <Typography
            sx={{
              mb: 3,
              fontSize:pxToRem(30),
              color: 'primary.main',
              fontWeight: (theme) => theme.typography.fontWeightBold,
            }}
          >
            {titre}
          </Typography>:<></>}
          {children}
        </Box>
      </ScrollBox>
    </LocalizationProvider>
  );
}
