// ----------------------------------------------------------------------

const ROOTS = {
  AUTH: '/auth',
  DASHBOARD: '/dashboard',
};

// ----------------------------------------------------------------------

// Définition des chemins d'accès dans l'application
export const paths = {
  // AUTH
  auth: {
    jwt: {
      login: `${ROOTS.AUTH}/jwt/login`,
      signIn: `${ROOTS.AUTH}/jwt/sign-in`,
      signUp: `${ROOTS.AUTH}/jwt/sign-up`,
      changePassword: `${ROOTS.AUTH}/jwt/change-password`,
    },
  },
  // DASHBOARD
    dashboard: {
      root: ROOTS.DASHBOARD,
      exploitation: {
        root: `${ROOTS.DASHBOARD}/exploitation`,
        circuitUsager: {
          root: `${ROOTS.DASHBOARD}/exploitation/circuit-usager`,
          usager: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/usager`,
          circuit: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/circuit`,
          trajet: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/trajet`,
          avenant: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/avenant`,
          absence: `${ROOTS.DASHBOARD}/exploitation/circuit-usager/absence`,
        },
        contract: `${ROOTS.DASHBOARD}/exploitation/contract`,
        client: `${ROOTS.DASHBOARD}/exploitation/client`,
        establishment: {
          root: `${ROOTS.DASHBOARD}/exploitation/establishment`,
          liste: `${ROOTS.DASHBOARD}/exploitation/establishment/liste`,
          holiday: `${ROOTS.DASHBOARD}/exploitation/establishment/holiday`,
          feuillePresence: `${ROOTS.DASHBOARD}/exploitation/establishment/feuille-presence`,
        },
        infrastructure: `${ROOTS.DASHBOARD}/exploitation/infrastructure`,
        chauffeur: {
          root: `${ROOTS.DASHBOARD}/exploitation/chauffeur`,
          liste: `${ROOTS.DASHBOARD}/exploitation/chauffeur/liste`,
          planning: `${ROOTS.DASHBOARD}/exploitation/chauffeur/planning`,
          feuilleRoute: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route`,
          envoiFeuilleRoute: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route/add-new-roadmap`,
          submittedRoadMap: `${ROOTS.DASHBOARD}/exploitation/chauffeur/feuille-route/submitted-roadmap`,
          suiviTrajet: `${ROOTS.DASHBOARD}/exploitation/chauffeur/suivi-trajet`,
          absence: `${ROOTS.DASHBOARD}/exploitation/chauffeur/absence`,
        },
        tad: `${ROOTS.DASHBOARD}/exploitation/tad`,
        preparation: {
          root: `${ROOTS.DASHBOARD}/exploitation/preparation`,
          usager: `${ROOTS.DASHBOARD}/exploitation/preparation/usager`,
          circuit: `${ROOTS.DASHBOARD}/exploitation/preparation/circuit`,
          chauffeur: `${ROOTS.DASHBOARD}/exploitation/preparation/chauffeur`,
        },
        gestionFlottes: {
          root: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes`,
          location: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/location`,
          vehicule: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/vehicule`,
          entretien: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/entretien`,
          assurance: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/assurance`,
          incidents: `${ROOTS.DASHBOARD}/exploitation/gestion_flottes/incidents`,
        },
        carburant: {
          root: `${ROOTS.DASHBOARD}/exploitation/carburant`,
          suiviCarburant: `${ROOTS.DASHBOARD}/exploitation/carburant/suivi_carburant`,
          suiviKilometrage: `${ROOTS.DASHBOARD}/exploitation/carburant/suivi_kilometrage`,
          anomalieTraitee: `${ROOTS.DASHBOARD}/exploitation/carburant/anomalie_traitee`,
        },
      },
      configAdmin: {
        root: `${ROOTS.DASHBOARD}/config-admin`,
        agentRole: `${ROOTS.DASHBOARD}/config-admin/agent-role`,
        email: `${ROOTS.DASHBOARD}/config-admin/email`,
        notification: `${ROOTS.DASHBOARD}/config-admin/notification`,
      },
      facturationPaiement: {
        root: `${ROOTS.DASHBOARD}/facturation-paiement`,
      },
      flottes: {
        root: `${ROOTS.DASHBOARD}/flottes`,
        location: `${ROOTS.DASHBOARD}/flottes/location`,
        vehicle: {
          root: `${ROOTS.DASHBOARD}/flottes/vehicule`,
          park: `${ROOTS.DASHBOARD}/flottes/vehicule/parc`,
          brands: `${ROOTS.DASHBOARD}/flottes/vehicule/marques-modeles`,
          mileage: `${ROOTS.DASHBOARD}/flottes/vehicule/kilometrage`,
        },
        consumption: {
          root: `${ROOTS.DASHBOARD}/flottes/consommation`,
          fuel: `${ROOTS.DASHBOARD}/flottes/consommation/carburant`,
          fees: `${ROOTS.DASHBOARD}/flottes/consommation/frais`,
          import: `${ROOTS.DASHBOARD}/flottes/consommation/import`,
          suiviCartes:`${ROOTS.DASHBOARD}/flottes/consommation/suiviCartes`,
          tanker: `${ROOTS.DASHBOARD}/flottes/consommation/petrolier`,
        },
        supplier: {
          root: `${ROOTS.DASHBOARD}/flottes/supplier`,
          supplierTypes: `${ROOTS.DASHBOARD}/flottes/supplier/types-fournisseurs`,
        },
        carbonReport: `${ROOTS.DASHBOARD}/flottes/bilan-carbon`,
        anomaly: `${ROOTS.DASHBOARD}/flottes/anomalie`,
        configAnomaly: `${ROOTS.DASHBOARD}/flottes/config-anomaly`,
        revision: `${ROOTS.DASHBOARD}/flottes/revision`,
        maintenance: {
          root: `${ROOTS.DASHBOARD}/flottes/entretien`,
          repair: `${ROOTS.DASHBOARD}/flottes/entretien/reparation`,
        },
        assignment: `${ROOTS.DASHBOARD}/flottes/affectation`,
        incidents: `${ROOTS.DASHBOARD}/flottes/incidents`,
        document: `${ROOTS.DASHBOARD}/flottes/document`,
      },
      geolocalisation: {
        root: `${ROOTS.DASHBOARD}/geolocalisation`,
        history: `${ROOTS.DASHBOARD}/geolocalisation/history`,
      },
      appelOffre: {
        root: `${ROOTS.DASHBOARD}/appel-offre`,
      },
      planning: {
        root: `${ROOTS.DASHBOARD}/planning`,
        vehicule: `${ROOTS.DASHBOARD}/planning/vehicule`,
        chauffeur: `${ROOTS.DASHBOARD}/planning/chauffeur`,
        location: `${ROOTS.DASHBOARD}/planning/location`,
      },
      rh: {
        root: `${ROOTS.DASHBOARD}/rh`,
        embauche: {
          root: `${ROOTS.DASHBOARD}/rh/recrutement`,
          candidatures: `${ROOTS.DASHBOARD}/rh/recrutement/candidatures`,
          candidaturesSedentaire: `${ROOTS.DASHBOARD}/rh/recrutement/candidatures-sedentaire`,
          besoinsRecrutement: `${ROOTS.DASHBOARD}/rh/recrutement/besoins-recrutement`,
          formulaire: `${ROOTS.DASHBOARD}/rh/recrutement/formulaire`,
        },
        salarié: `${ROOTS.DASHBOARD}/rh/salarie`,
        calendar: `${ROOTS.DASHBOARD}/rh/calendar`,
        absence: `${ROOTS.DASHBOARD}/rh/absence`,
        conge: `${ROOTS.DASHBOARD}/rh/conge`,
        rdvAnnuel: `${ROOTS.DASHBOARD}/rh/rdv-annuel`,
        document: `${ROOTS.DASHBOARD}/rh/document`,
      },
      staff: {
        root: `${ROOTS.DASHBOARD}/staff`,
        absence:`${ROOTS.DASHBOARD}/staff/absence`,
        document:`${ROOTS.DASHBOARD}/staff/document`,
        profil:`${ROOTS.DASHBOARD}/staff/profil`,
        email:`${ROOTS.DASHBOARD}/staff/email`,
        profilDetails:`${ROOTS.DASHBOARD}/staff/profil/information`,
        profilStatus:`${ROOTS.DASHBOARD}/staff/profil/status`,
        profilNotifications:`${ROOTS.DASHBOARD}/staff/profil/notifications`,
        profilLanguesAndRegion:`${ROOTS.DASHBOARD}/staff/profil/languesandregion`,
        profilpassword:`${ROOTS.DASHBOARD}/staff/profil/password`,
        profilsessionHistorique:`${ROOTS.DASHBOARD}/staff/profil/sessionHistorique`,
      },
      export: {
        root: `${ROOTS.DASHBOARD}/export`,
      },
  }
};

