import { generateStartDate } from ".";
import { TableColumn } from "../types/common";


export type IContrat = {
  id: string;
  dateMarche: string;
  dateRenouvellement: string;
  dateFin: string;
  codeContrat: string;
  intitule: string;
  client: string;
  societe: string;
  agence: string;
  numeroMarche: string;
  numeroLot: string;
  status: string;
  isActive: boolean;
  dateDebut?: string;
  grillePrix?: string;
  dateRevisionPrix?: string;
  frequence?: string;
  numeroEngagement?: string;
  dureeMarche?: string;
  reconduction?: 'oui' | 'non';
  typeContratTAD?: 'oui' | 'non';
  observation?: string;
  description?: string;
  color?: string;
};

export const _CONTRACT_STATUS = [
  { value: "en_cours", label: "En cours" },
  { value: "nouveau", label: "Nouveau" },
  { value: "resilie", label: "Résilié" },
  { value: "termine", label: "Terminé" },
  { value: "archive", label: "Archivé" },
];
export const _OPTION_ACTIF = [
  { value: "true", label: "Actif" },
  { value: "false", label: "Inactif" },
];

const priceGrids = [
  "PG-Standard-A",
  "PG-Premium-B",
  "PG-Economy-C",
  "PG-Flex-D",
  "PG-Custom-E"
];

const frequencies = [
  "Mensuelle",
  "Trimestrielle", 
  "Semestrielle",
  "Annuelle",
  "Ponctuelle"
];

  export const _contracts :IContrat[] = [...Array(55)].map((_, index) => {
    const marketDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
    const renewalDate = new Date(marketDate);
    renewalDate.setFullYear(renewalDate.getFullYear() + 1);
    const endDate = new Date(renewalDate);
    endDate.setFullYear(endDate.getFullYear() + 1);
    const contractCode = `CC${(12345 + index).toString().padStart(5, '0')}`;

    return {
      id: (index + 1).toString(),
      dateMarche: marketDate.toISOString().split('T')[0],
      dateRenouvellement: renewalDate.toISOString().split('T')[0],
      dateFin: endDate.toISOString().split('T')[0],
      codeContrat: contractCode,
      intitule: [
        "Transport Scolaire",
        "Contrat Interurbain",
        "Transport Public",
        "Service Express",
        "Navette Aéroport"
      ][index % 5],
      client: [
        "École Soleil",
        "Collège Central",
        "Lycée Nord",
        "École Est",
        "Institut Ouest"
      ][index % 5],
      societe: [
        "Global",
        "TransExpress",
        "CityBus",
        "MetroLink",
        "RapidTransit"
      ][index % 5],
      agence: [
        "M-1026",
        "M-1027",
        "M-1028",
        "M-1029",
        "M-1030"
      ][index % 5],
      numeroMarche: `${12345 + index}/890`,
      dateDebut:'',
      color:'',
      grillePrix: priceGrids[index % 5],
      dateRevisionPrix: generateStartDate(index),
      frequence: frequencies[index % 5],
      numeroLot: `BCI${(256579345 + index).toString().padStart(9, '0')}`,
      status: _CONTRACT_STATUS[index % 5].value,
      numeroEngagement:'',
      dureeMarche: '',
      reconduction: Math.random() > 0.5 ? "oui" : "non",
      typeContratTAD: Math.random() > 0.7 ? "oui" : "non",
      observation:'',
      description: '',
      isActive: Math.random() < 0.6,
      
    };
  });
  
  export const getContractStatus = (status: string): string => {
    const statusObj = _CONTRACT_STATUS.find(s => s.value === status);
    return statusObj ? statusObj.label : "Inconnu";
  };
  export const DEFAULT_TABLE_HEAD: TableColumn[] = [
    { id: 'id', label: 'N° Contrat', type: 'text' },
    { id: 'dateMarche', label: 'Date de Marché', type: 'date'},
    { id: 'dateRenouvellement', label: 'Date de Renouvellement', type: 'date'},
    { id: 'dateFin', label: 'Date de fin', type: 'date'},
    { id: 'codeContrat', label: 'Code de contrat', type: 'text'},
    { id: 'intitule', label: 'Intitulé', type: 'text' },
    { id: 'client', label: 'Client', type: 'text' },
    { id: 'societe', label: 'Société', type: 'text' },
    { id: 'agence', label: 'Agence', type: 'text' },
    { id: 'numeroMarche', label: 'N° de marché', type: 'text' },
    { id: 'numeroLot', label: 'N° de lot', type: 'text' },
    { id: 'status', label: 'Status', type: 'status' },
    { id: 'isActive', label: 'Active', type: 'boolean' },
    { id: '', label: 'Action' },
  ];
  
  export const INITIAL_CONTRACT_DATA: IContrat = {
    id: '',
    dateMarche: '',
    dateRenouvellement: '',
    dateFin: '',
    codeContrat: '',
    intitule: '',
    client: '',
    societe: '',
    agence: '',
    numeroMarche: '',
    numeroLot: '',
    status: 'nouveau',
    isActive: true,
    dateDebut: '',
    grillePrix: '',
    dateRevisionPrix: '',
    frequence: '',
    numeroEngagement: '',
    dureeMarche: '',
    reconduction: 'non',
    typeContratTAD: 'non',
    observation: '',
    description: '',
    color: '',
  };