import { _noms } from '.';
import { DriverAbsenceStatut } from '../api/stores/driverAbsenceStore';
import { EtatDemandeRecue } from '../types/absence';
import { TableColumn } from '../types/common';
import { IDriverAbsence } from '../types/driver-absence';
import { Departements } from '../types/etablissement';
import { BinaryQuestion } from '../types/trajet';
import { DRIVERS } from './_appointment';

export const _CHAUFFEURS = ['Anna Leblanc', 'Thomas Dubois', 'Marie Martin', 'Lucas Bernard'];
export const _MODES_RECEPTION = ['MAIL', 'SMS', 'PORTAL'];

export const _OPTION_MODES_RECEPTION = [
  { value: 'MAIL', label: 'Mail' },
  { value: 'SMS', label: 'SMS' },
  { value: 'PORTAL', label: 'Portail' },
];

export const _TYPES_ABSENCE_LABEL = ['Mission', 'Télétravail', 'Congé', 'Maladie', 'Autre'];
export enum _TYPES_ABSENCE {
  EXTERNAL_ASSIGNMENT = 'EXTERNAL_ASSIGNMENT',
  EXCEPTIONAL_REMOTE_WORK = 'EXCEPTIONAL_REMOTE_WORK',
  AUTHORIZED_ABSENCE = 'AUTHORIZED_ABSENCE',
  UNAUTHORIZED_ABSENCE = 'UNAUTHORIZED_ABSENCE',
  MEDICAL_APPOINTMENT = 'MEDICAL_APPOINTMENT',
}

export const _OPTION_TYPES_ABSENCE = [
  { value: _TYPES_ABSENCE.EXTERNAL_ASSIGNMENT, label: 'Mission' },
  { value: _TYPES_ABSENCE.EXCEPTIONAL_REMOTE_WORK, label: 'Télétravail' },
  { value: _TYPES_ABSENCE.AUTHORIZED_ABSENCE, label: 'Absence autorisée' },
  { value: _TYPES_ABSENCE.UNAUTHORIZED_ABSENCE, label: 'Absence non autorisée' },
  { value: _TYPES_ABSENCE.MEDICAL_APPOINTMENT, label: 'Rendez-vous médical' },
]

export const _OPTION_DRIVER_ABSENCE = [
  { value: DriverAbsenceStatut.IN_PROGRESS, label: 'En cours' },
  { value: DriverAbsenceStatut.INVALID, label: 'Non traité' },
  { value: DriverAbsenceStatut.ACCEPTED, label: 'Validé' },
  { value: DriverAbsenceStatut.REJECTED, label: 'Rejeté' },
];

export const _OPTION_DRIVER_ABSENCE_UNPRO = [
  { value: DriverAbsenceStatut.IN_PROGRESS, label: 'En cours' },
  { value: DriverAbsenceStatut.INVALID, label: 'Non traité' },
];
export const _OPTION_DRIVER_ABSENCE_PRO = [
  { value: DriverAbsenceStatut.ACCEPTED, label: 'Validé' },
  { value: DriverAbsenceStatut.REJECTED, label: 'Rejeté' },
];


export const DEFAULT_ABSENCE_DRIVER_TABLE_HEAD = (isNonTraite: boolean): TableColumn[] => [
  { id: 'id', label: "N° d'enregistrement", type: 'text', align: 'center' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text' , isNotSortable: true},
  { id: 'typeAbsence', label: "Type d'absence", type: 'select', options: _OPTION_TYPES_ABSENCE },
  { id: 'dateDebut', label: 'Début', type: 'date', align: 'center' },
  { id: 'dateFin', label: 'Fin', type: 'date', align: 'center' },
  {
    id: 'chauffeurAffecte', label: 'Chauffeur Affecté', type: 'select',  options: [
      { value: BinaryQuestion.Oui, label: 'Oui' }, { value: BinaryQuestion.Non, label: 'Non' }
    ]
  },
  { id: 'modeReception', label: 'Mode de réception', type: 'select', options: _OPTION_MODES_RECEPTION },
  { id: 'nombreHeures', label: "Nombre d'heures", type: 'text', align: 'center' },
  { id: 'authorizedByName', label: 'Autorisé Par',  isNotSortable: true ,type: 'text', align: 'center' },
  { id: 'statut', label: 'Statut', type: 'select', options: isNonTraite ? _OPTION_DRIVER_ABSENCE_UNPRO : _OPTION_DRIVER_ABSENCE_PRO },
  ...(isNonTraite ? [] : [{ id: 'validatedByName', label: 'Validé Par', isNotSortable: true ,type: 'text' }]),
  { id: 'justificatif', label: 'Justificatif', type: '' , isNotSortable: true},
  { id: 'actions', label: 'Action' },
];

export const INITIAL_ABSENCE_DRIVER_DATA = (isNonTraite: boolean): IDriverAbsence => ({
  id: '',
  chauffeur: '',
  driverName: '',
  typeAbsence: '',
  dateDebut: '',
  dateFin: '',
  chauffeurAffecte: BinaryQuestion.Non,
  modeReception: '',
  nombreHeures: '',
  autorisePar: '',
  validePar: '',
  validatedByName: null,
  authorizedByName: null,
  justificatif: new File([], ''),
  statut: isNonTraite ? DriverAbsenceStatut.INVALID : DriverAbsenceStatut.ACCEPTED
});
