import { Civility, TableColumn } from "../types/common";
import {CollaboratorStatus, ContractType, IAgent, UserStatus } from '@/shared/types/client';
import { ADRESSE, INITIAL_ADDRESS, MOCK_ADDRESSES } from ".";

export const _AGENT_STATUS = [
  { value: 'APPROVED', label: "Approuvé" },
  { value: 'PENDING', label: "En attente" },
  { value: 'BANNED', label: "Banni" },
  { value: 'DELETED', label: "Supprimé" },
];

export const DEFAULT_AGENT_TABLE_HEAD: TableColumn[] = [
  { id: 'lastName', label: 'Nom', type: 'text' },
  { id: 'firstName', label: 'Prénom', type: 'text' },
  { id: 'role', label: 'Rôle', type: 'text', isNotSortable: true },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'address', label: 'Adresse', type: 'text' },
  { id: 'email', label: 'E-mail', type: 'text' },
  { id: 'phoneNumber', label: 'Téléphone', type: 'text' },
  { id: '', label: 'Actions' },
];

export const INITIAL_AGENT_DATA: IAgent = {
  id: '0',
  createdAt: '',
  updatedAt: '',

  // Champs IUser
  lastName: '',
  firstName: '',
  email: '',
  personalEmail: '',
  birthDate: '',
  birthPlace: '',
  civility: Civility.MM,
  phoneNumber: '',
  password: '',
  userStatus: UserStatus.INACTIF,
  photoUrl: '',
  isArchived: false,
  addresses: [],
  connectionHistory: [],
  roles: [],
  agentIdentifier: '',  
  departmentId: 0,
  departmentName: '',
  agencyId: 0,
  agencyName: '',
  teams: [],
  contractType: ContractType.CDI,
  socialSecurityNumber: '',
  collaboratorStatus: CollaboratorStatus.PENDING,
  folderId: undefined,
  schedule: {
    id: '0',
    collaboratorId: '0',
    weeklySchedule: {
      monday: { isWorkingDay: true, startTime: '09:00', endTime: '18:00', breakStartTime: '12:00', breakEndTime: '13:00' },
      tuesday: { isWorkingDay: true, startTime: '09:00', endTime: '18:00', breakStartTime: '12:00', breakEndTime: '13:00' },
      wednesday: { isWorkingDay: true, startTime: '09:00', endTime: '18:00', breakStartTime: '12:00', breakEndTime: '13:00' },
      thursday: { isWorkingDay: true, startTime: '09:00', endTime: '18:00', breakStartTime: '12:00', breakEndTime: '13:00'},
      friday: { isWorkingDay: true, startTime: '09:00', endTime: '18:00', breakStartTime: '12:00', breakEndTime: '13:00' },
      saturday: { isWorkingDay: false, startTime: null, endTime: null, breakStartTime: null, breakEndTime: null},
      sunday: { isWorkingDay: false, startTime: null, endTime: null, breakStartTime: null, breakEndTime: null},
    },
    createdAt: '',
    updatedAt: '',
  },
};


const FRENCH_NAMES = {
  lastNames: [
    'Dubois', 'Martin', 'Bernard', 'Thomas', 'Petit', 'Robert', 'Richard',
    'Durand', 'Leroy', 'Moreau', 'Simon', 'Laurent', 'Lefebvre', 'Michel',
    'Garcia', 'David', 'Bertrand', 'Roux', 'Vincent', 'Fournier'
  ],
  firstNames: [
    'Emma', 'Lucas', 'Léa', 'Louis', 'Chloé', 'Hugo', 'Inès', 'Gabriel',
    'Alice', 'Jules', 'Louise', 'Arthur', 'Lina', 'Paul', 'Rose', 'Nathan',
    'Camille', 'Adam', 'Léna', 'Raphaël'
  ],
  cities: [
    'Paris', 'Lyon', 'Marseille', 'Bordeaux', 'Lille', 'Toulouse', 'Nantes',
    'Strasbourg', 'Montpellier', 'Nice', 'Rennes', 'Grenoble', 'Angers',
    'Dijon', 'Le Mans', 'Clermont-Ferrand', 'Amiens', 'Caen', 'Limoges', 'Metz'
  ],
  streets: [
    'rue de la République', 'avenue des Champs-Élysées', 'boulevard Saint-Michel',
    'rue de la Paix', 'avenue Victor Hugo', 'rue du Commerce', 'boulevard Haussmann',
    'rue de Rivoli', 'avenue Foch', 'rue Lafayette'
  ],
  agencies: [
    'Agence Centrale', 'Agence Nord', 'Agence Sud', 'Agence Est', 'Agence Ouest'
  ],
  departments: [
    'Commercial', 'Ressources Humaines', 'Comptabilité', 'Technique'
  ]
};

// Mock data generation...
export const _agents = [...Array(20)].map((_, index) => {
  const connectionHistory = [...Array(5)].map((_, i) => {
    const date = new Date();
    date.setDate(date.getDate() - i);
    const startTime = new Date(date);
    startTime.setHours(8 + Math.floor(Math.random() * 2), Math.floor(Math.random() * 60), 0);

    const endTime = new Date(startTime);
    const duration = 480 + Math.floor(Math.random() * 120);
    endTime.setMinutes(endTime.getMinutes() + duration);

    return {
      id: `CONN-${index}-${i}`,
      startTime: startTime.toISOString(),
      endTime: endTime.toISOString(),
      duration: duration,
      date: date.toISOString().split('T')[0],
    };
  });

  const lastName = FRENCH_NAMES.lastNames[index % FRENCH_NAMES.lastNames.length];
  const firstName = FRENCH_NAMES.firstNames[index % FRENCH_NAMES.firstNames.length];
  const teamIndex = Math.floor(Math.random() * 5);

  // Générer un emploi du temps aléatoire
  const generateRandomSchedule = () => {
    const workingDays = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday'];
    const schedule: any = {};
    
    ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'].forEach(day => {
      const isWorkingDay = workingDays.includes(day);
      schedule[day] = {
        isWorkingDay,
        startTime: isWorkingDay ? '09:00' : null,
        endTime: isWorkingDay ? '17:00' : null,
        breakStartTime: isWorkingDay ? '12:00' : null,
        breakEndTime: isWorkingDay ? '13:00' : null,
        notes: isWorkingDay ? (Math.random() > 0.7 ? 'Notes spéciales' : '') : '',
      };
    });
    
    return schedule;
  };

  return {
    id: `AG${(index + 1).toString().padStart(5, '0')}`,
    lastName,
    firstName,
    birthDate: new Date(1980 + (index % 20), index % 12, 15).toISOString().split('T')[0],
    birthPlace: FRENCH_NAMES.cities[Math.floor(Math.random() * FRENCH_NAMES.cities.length)],
    address: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    phone: `+33${Math.floor(Math.random() * 900000000 + 100000000)}`,
    email: `${firstName.toLowerCase()}.${lastName.toLowerCase()}@example.com`,
    personalEmail: `${firstName.toLowerCase()}.${lastName.toLowerCase()}@gmail.com`,
    socialSecurityNumber: `${Math.floor(Math.random() * 1000000000)}`,
    agentId: `AGT${(index + 1).toString().padStart(5, '0')}`,
    agency: FRENCH_NAMES.agencies[index % FRENCH_NAMES.agencies.length],
    password: 'Password123!',
    department: FRENCH_NAMES.departments[index % FRENCH_NAMES.departments.length],
    team: index % 3 === 0 ? `TM${(12345 + teamIndex).toString().padStart(5, '0')}` : '',
    contractType: ['CDI', 'CDD', 'Intérim'][index % 3],
    status: _AGENT_STATUS[index % _AGENT_STATUS.length].value,
    role: ['Admin', 'Manager', 'Agent'][index % 3],
    permissions: ['Lecture', 'Écriture', 'Modification', 'Suppression'].slice(0, index % 4 + 1),
    isActive: Math.random() > 0.2,
    connectionHistory,
    schedule: {
      id: `SCH${(index + 1).toString().padStart(5, '0')}`,
      collaboratorId: `AG${(index + 1).toString().padStart(5, '0')}`,
      weeklySchedule: generateRandomSchedule(),
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
    },
  };
});