import { ActionType, AmendmentPassengerDetails, AmendmentPassengerScheduleDTO, PeriodOfDay } from "@/shared/types/ammendment-passenger";
import { DaysOfWeek, SensTrip } from "@/shared/types/passenger";
import { JoursAttribues } from "../types/chauffeur";
import { TableColumn } from "../types/common";
import { IAvenantUsager } from "../types/usager";

export const _avenants_usagers = [...Array(5)].map((_, index) => {
  const startDate = new Date(2020 + Math.floor(index / 12), index % 12, 15);
  const actionAvenantList = Object.values(ActionType);
  return {
    id: (index + 1).toString(),
    numeroAvenant: `${(index+1).toString().padStart(5, '0')}`,
    dateApplication: startDate.toISOString().split('T')[0],
    codeCircuit: `CIR-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`,
    intituleCircuit: `Avenant ${index + 1}`,
    objetAvenant: ["Adresse Domicile", "Horaires", "Véhicule", "Tarification"][index % 4],
    etablissement: ['les_champs', 'la_colline', 'le_rivage', 'la_foret'].slice(index % 4, index % 4 + 1),
    observation: ['Ce bus facilite les déplacements urbains.', 'Bus facilite les déplacements urbains.'][Math.floor(Math.random() * 2)],
    specificite: '',
    actionAvenant: actionAvenantList[Math.floor(Math.random() * actionAvenantList.length)],
    avenantTemporaire:''
  };
});
export const etablissementsOptions = [
  { label: 'Les Champs', value: 'les_champs' },
  { label: 'La Colline', value: 'la_colline' },
  { label: 'Le Rivage', value: 'le_rivage' },
  { label: 'La Forêt', value: 'la_foret' },
];

export const DEFAULT_AMENDMENT_PASSENGER_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Avenant', type: 'text' },
  { id: 'startDate', label: 'A partir du', type: 'date' },
  { id: 'subject', label: 'Objet de l\'avenant', type: 'text' },
  { id: 'circuitCode', label: 'Code', type: 'text', isNotSortable :true },
  { id: 'circuitName', label: 'Circuit', type: 'text', isNotSortable :true },
  { id: 'observation', label: 'Observation', type: 'text' },
  { id: 'createdAt', label: 'Crée le', type: 'date' },
];
export const DEFAULT_AMENDMENT_PASSENGER_CIRCUIT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Avenant', type: 'text' },
  { id: 'startDate', label: 'A partir du', type: 'date' },
  { id: 'subject', label: 'Objet de l\'avenant', type: 'text' },
  { id: 'observation', label: 'Observation', type: 'text' },
  { id: 'createdAt', label: 'Crée le', type: 'date' },
];

export const createEmptyJoursAttribues = (): JoursAttribues => {
  return {
    pair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
    impair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
  }
}

const createMockScheduleWeek = (weekType: string): AmendmentPassengerScheduleDTO[] => {
  const schedule: AmendmentPassengerScheduleDTO[] = [];
  const weekDays = [
    DaysOfWeek.MONDAY,   
    DaysOfWeek.TUESDAY,  
    DaysOfWeek.WEDNESDAY, 
    DaysOfWeek.THURSDAY,  
    DaysOfWeek.FRIDAY     
  ];

  weekDays.forEach(dayOfWeek => {
    schedule.push({
      sensTrip: SensTrip.DEPARTURE,
      dayOfWeek,
      periodOfDay: PeriodOfDay.MORNING,
      scheduledTime: "08:00:00"
    });

    schedule.push({
      sensTrip: SensTrip.RETURN,
      dayOfWeek,
      periodOfDay: PeriodOfDay.EVENING,
      scheduledTime: "18:00:00"
    });
  });

  return schedule;
};

export const INITIAL_AVENANT_USAGERS_DATA: AmendmentPassengerDetails = {
  id: '',
  subject: '',
  observation: '',
  creationType: 'MANUAL',
  actionType: ActionType.ADD_PASSENGER,
  startDate: '',
  endDate: '',
  amendmentType: 'AMENDMENT_PASSENGER',
  specificity: '',
  passengerId: 0,
  triggeredAmendmentCircuitId: '',
  passengerScheduleWeeks: [
    {
      id: null,
      weekType: 'EVEN',
      amendmentPassengerSchedule: createMockScheduleWeek('EVEN')
    },
    {
      id: null,
      weekType: 'ODD',
      amendmentPassengerSchedule: createMockScheduleWeek('ODD')
    }
  ],
  establishmentWeekPassengerMap: [],
  amendmentRepresentatives: []
};