import { Sens, TripCircuitDetails, TripState } from "../types/circuit";
import { DaysOfWeek, SensTrip, WeekType } from "../types/passenger";
import { TableColumn } from "../types/common";
import { faClock, faWheelchair } from "@fortawesome/free-solid-svg-icons";
import { EtatTrajet, TypeTrajet } from "../types/trajet";
import { PeriodOfDay } from "../types/ammendment-passenger";

const INTITULES = ['Lun - Mar 07:30', 'Mer-Jeu-Ven 8h', 'Lun 17h', 'Mar-Mer 18h','Jeu-Ven 17h:30'];
const USAGERS = ['Étudiants', 'Collégiens', 'Lycéens', 'Primaires'];
const ETS = ['Lycée Général', 'Collège', 'École Primaire', 'Lycée Professionnel'];
const CHAUFFEURS = ['Jean Dupont', 'Marie Martin', 'Pierre Bernard', 'Sophie Petit'];
const CIRCUITS = ['2211', '2212', '2213', '2214'];

export const _TRAJET_PRET = [
    { value: "oui", label: "Oui" },
    { value: "non", label: "Non" },
  ];
const getRandomItem = (array : string[]) => array[Math.floor(Math.random() * array.length)];

const generateKmAndTime = () => `${Math.floor(Math.random() * 200) + 100} km/3h`;


export const getTrajetPret = (status: string): string => {
  const statusObj = _TRAJET_PRET.find(s => s.value === status);
  return statusObj ? statusObj.label : "Inconnu";
};

export const _TRAJETS = [...Array(5)].map((_, index) => {
  const isPrimary = index % 2 === 0;
  const circuitCode = isPrimary ? 'EC-001' : 'SC-002';
  const startDate = new Date(2023 + Math.floor(index / 12), index % 12, 15);
  const usagersCount = Math.floor(Math.random() * 3) + 1
  const usagersList = Array(usagersCount)
    .fill(0)
    .map(() => getRandomItem(CHAUFFEURS))
  return {
    id: (index + 1).toString(),
    numeroTrajet: (index + 1).toString().padStart(6, '0'),
    preparation: Math.random() > 0.5 ? 'oui' : 'non',
    dateDebut: startDate.toISOString().split('T')[0],
    intitule: INTITULES[index],
    sensAR: index < 2  ? Sens.Aller : Sens.Retour, 
    kmEtTemps: generateKmAndTime(),
    usagers: usagersList,
    ets: getRandomItem(ETS),
    codeTrajetCircuit: `${circuitCode}-${(index + 1).toString().padStart(3, '0')}`,
    circuit: getRandomItem(CIRCUITS),
    etat: index % 3 === 0 ? EtatTrajet.Controle : EtatTrajet.NonControle,
    chauffeur: getRandomItem(CHAUFFEURS)
  };
});
export const DEFAULT_CIRCUIT_TRAJET_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Trajet', type: 'text', align: 'center' },
  { id: 'preparation', label: 'Préparation', type: 'status', align: 'center' },
  { id: 'dateDebut', label: 'Date de début', type: 'date', align: 'center' },
  { id: 'tripTitled', label: 'Intitulé', type: 'text', align: 'left' },
  { id: 'sensTrip', label: 'Sens (Aller/Retour)', type: 'text', align: 'center' },
  { id: 'kmEtTemps', label: 'Distance & Temps', type: 'text', align: 'center' },
  { id: 'passengerInfo', label: 'Usagers', type: 'text', align: 'left' },
  { id: 'establishemntName', label: 'Ets', type: 'text', align: 'left' },
  { id: 'circuitCode', label: 'code circuit', type: 'text', align: 'left' },
  { id: 'circuitTitled', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'tripState', label: 'État', type: 'status', align: 'center' },
  { id: 'driverName', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'createdAt', label: 'Créé le', type: 'date', align: 'center' },
  { id: '', label: 'Action' },
];

export const DEFAULT_CUSTOMIZED_TRIPS_TABLE_HEAD: TableColumn[] = (() => {
  const baseColumns = [...DEFAULT_CIRCUIT_TRAJET_TABLE_HEAD];
  const preparationIndex = baseColumns.findIndex(col => col.id === 'preparation');
  if (preparationIndex >= 0) {
    baseColumns[preparationIndex] = {
      id: 'customizedDate',
      label: 'Date de personnalisation',
      type: 'date',
      align: 'center',
    };
  }
  return baseColumns;
})();

export const INITIAL_CIRCUIT_TRAJET_DATA: TripCircuitDetails = {
  id: '',
  createdAt: '',
  updatedAt: '',
  tripTitled: '',
  tripState: TripState.UNCONTROLLED,
  circuitTitled: '',
  lastAmendmentDate: '',
  tripType: '',
  customizedDate: '',
  hasTolls: false,
  sens: SensTrip.DEPARTURE,
  rotation: false,
  routeSheetNote: '',
  tripObservation: '',
  weeklySchedules: [],
  duration: '',
  distanceKm: 0,
  shortestPath: null,
  tripHour: '',
  tripPoints: [],
  contractShortResponseDTO: {
    id: '',
    createdAt: '',
    updatedAt: '',
    title: '',
    contractCode: '',
    contractColor: '',
  },
  lot: {
    id: 0,
    lotNumber: '',
  },
};

//details circuit
export const passengers = [
    {
      name: 'Jean Dupont',
      schedule: 'Mer-Jeu-Ven 8h',
      phone: '+33 6 12 34 56 78',
      route: 'La Défense→Quartier Les ecoles (2 Km)',
      times: ['07:30 AM', '08:00 AM', '17:00 PM', '18:00 PM', '17:30 PM'],
      observation:
        'la propreté à bord des véhicules pourrait être améliorée pour offrir une meilleure expérience aux passagers.',
    },
    {
      name: 'Jean Dupont',
      schedule: 'Mer-Jeu-Ven 8h',
      phone: '+33 6 12 34 56 78',
      route: 'La Défense→Quartier Les ecoles (2 Km)',
      times: ['07:30 AM', '08:00 AM', '17:00 PM', '18:00 PM', '17:30 PM'],
      observation:
        'la propreté à bord des véhicules pourrait être améliorée pour offrir une meilleure expérience aux passagers.',
    },
  ];

export const summaryRows = [
    {
      label: 'kilomètre en charge',
      icon: '/assets/icons/menu/ic_exploitation.svg',
      values: [10, 10, 10, 10, 10],
      total: 'Total de kilomètre en charge: 60Km',
    },
    {
      label: 'Temps en charge',
      icon: faClock,
      values: [10, 10, 10, 10, 10],
      total: 'Total de kilomètre en charge: 60Km',
    },
    {
      label: 'Usagers en charge',
      icon: faWheelchair,
      values: [3, 3, 2, 1, 1],
      total: 'Total de Usagers en charge: 10Km',
    },
  ];
  export const timeSlots = [
    { id: '0000001', days: 'Lun - Mar', time: '07:30' },
    { id: '0000002', days: 'Mer-Jeu-Ven', time: '8h' },
    { id: '0000003', days: 'Lun', time: '17h' },
    { id: '0000004', days: 'Mar-Mer', time: '18h' },
    { id: '0000005', days: 'Jeu-Ven', time: '17h30' },
  ];

  export const MOCKED_CIRCUIT_TRAJET: TripCircuitDetails = {
    id: 'mocked-circuit-real-data',
    createdAt: '2025-07-18T15:23:00.323',
    updatedAt: '2025-07-18T15:23:00.323',
    circuitTitled: 'Circuit Mock Réel',
    tripTitled: 'Trajet Mock Réel',
    tripState: TripState.CONTROLLED,
    lastAmendmentDate: '2025-07-16T00:00:00',
    tripType: TypeTrajet.Normal,
    customizedDate: '',
    hasTolls: false,
    sens: SensTrip.DEPARTURE,
    rotation: false,
    routeSheetNote: '',
    tripObservation: '',
    duration: '1901',
    distanceKm: 22.13,
    shortestPath: {
      bbox: [4.593679, 44.730139, 4.672677, 44.746111],
      routes: [
        {
          summary: {
            distance: 22131.2,
            duration: 1901.2,
          },
          geometry: 'kj_pGgf`[QI_@DoAZY?a@Q[[Oa@Ko@EeESmB?MAMMy@Ke@ACQLwBeAUSu@s@MC[Ha@d@OT]pACXSvB?Bw@OYO@o@CQSDWIGIIUYyCa@kEEWGO@MAKIGG@Ei@@iBD_C?sF?e@LK@UKOODkAoBi@uACQMeACm@@q@J{Ab@sAlGgMFi@Cg@M[uBeC[u@WcAAqAR{COu@e@a@_AmA}@yA}@oBOcA_@gE_AmDi@cBc@eBGQq@gCCm@H_@b@m@n@]xAL|A?^I`@[x@gAd@mADU?_@Ks@[oA[iA]g@_@Qm@BmATk@GcAa@cAy@_@aAKmA?cAJmAT}@nBwBl@}@DEJULWd@cAN_@Hc@BWAWGq@I[k@kBQa@CKo@iBSk@S{@E}@RgBr@kFh@cA^c@pAk@Za@R{@^qDReBB_@@GD]f@}EBeACg@Im@Oq@_BaEkAyCQe@KWYgAOmAu@iPE_AMsCQwB_@aBkD_L[eAScA[gDiAaOScCQcAiBgEm@aDQaAa@mDBaGByCg@}NgA}IE{CEk@_@gBgAeC]e@kB{Bg@o@s@kA_BwD_BuDYq@]aAOu@G{@@o@Bk@t@gGDy@?u@a@sCUoAo@kBa@iAuEoKISHRtEnK`@hAn@jBTnA`@rC?t@Ex@u@fGCj@An@Fz@Nt@\\`AXp@~AtD~AvDr@jAf@n@jBzB\\d@fAdC^fBDj@DzCfA|If@|NCxCC`G`@lDP`Al@`DhBfEPbARbChA`OZfDRbAZdAjD~K^`BPvBLrCD~@t@hPNlAXfAJVPd@jAxC~A`ENp@Hl@Bf@CdAg@|EE\\AFC^SdB_@pDSz@[`@qAj@_@b@i@bAs@jFSfBD|@Rz@Rj@n@hBBJP`@j@jBHZFp@@VCVIb@O^e@bAMVKTEDm@|@oBvBU|@KlA?bAJlA^`AbAx@bA`@j@FlAUl@C^P\\f@ZhAZnAJr@?^ETe@lAy@fAa@Z_@H}A?yAMo@\\c@l@I^Bl@p@fCFPb@dBh@bB~@lD^fENbA|@nB|@xA~@lAd@`@Nt@SzC@pAVbAZt@tBdCLZBf@Gh@mGfMc@rAKzAAp@Bl@LdA[XmCjDEMAq@HkCNeGF{BNsCp@oHrBDHBICsBEq@nHOrCGzBk@SwBeAS?OFQPOd@Eb@Cx@ClABTDL?TEPC\\JfCHxAD^JZJLPHP?NGn@m@HCb@@LHJNHQJKOc@lCkDZYMeACm@@q@J{Ab@sAlGgMFi@Cg@M[uBeC[u@WcAAqAR{COu@e@a@_AmA}@yA}@oBOcA_@gE_AmDi@cBc@eBGQq@gCCm@H_@b@m@n@]xAL|A?^I`@[x@gAd@mADU?_@Ks@[oA[iA]g@_@Qm@BmATk@GcAa@cAy@_@aAKmA?cAJmAT}@nBwBl@}@DEJULWd@cAN_@Hc@BWAWGq@I[k@kBQa@CKo@iBSk@S{@E}@RgBr@kFh@cA^c@pAk@Za@R{@^qDReBB_@@GD]f@}EBeACg@Im@Oq@_BaEkAyCQe@KWYgAOmAu@iPE_AMsCQwB_@aBkD_L[eAScA[gDiAaOScCQcAiBgEm@aDQaAa@mDBaGByCg@}NgA}IE{CEk@_@gBgAeC]e@kB{Bg@o@s@kA_BwD_BuDYq@]aAOu@G{@@o@Bk@t@gGDy@?u@a@sCUoAo@kBa@iAuEoKwAiD_DqHu@mD',
        },
      ],
    },
    tripHour: '17:00:00',
    tripPoints: [
      {
        id: 'mocked-point-1',
        createdAt: '2025-07-18T15:23:00.48',
        updatedAt: '2025-07-18T15:23:00.48',
        routeToNext: { distance: 7955.5, duration: 695.8 },
        passengerDetailsTrip: {
          fullName: 'Mohamad Moustafa',
          establishmentName: '',
          pickupTime: '17:11:35',
          startCoordinates: { latitude: 44.7447382, longitude: 4.6694345 },
        },
      },
      {
        id: 'mocked-point-2',
        createdAt: '2025-07-18T15:23:00.481',
        updatedAt: '2025-07-18T15:23:00.481',
        routeToNext: { distance: 1853.2, duration: 273.6 },
        passengerDetailsTrip: {
          fullName: 'Hugo Martin',
          establishmentName: '',
          pickupTime: '17:16:09',
          startCoordinates: { latitude: 44.746226, longitude: 4.6726071 },
        },
      },
      {
        id: 'mocked-point-3',
        createdAt: '2025-07-18T15:23:00.481',
        updatedAt: '2025-07-18T15:23:00.481',
        routeToNext: { distance: 0, duration: 0 },
        passengerDetailsTrip: {
          fullName: '',
          establishmentName: 'Lycée polyvalent vincent d\'indy',
          pickupTime: '17:00:00',
          startCoordinates: { latitude: 44.7447382, longitude: 4.6694345 },
        },
      },
    ],
    contractShortResponseDTO: {
      id: 'mocked-contract-1',
      createdAt: '2025-07-14T15:03:05.569979',
      updatedAt: '2025-07-14T15:12:22.583621',
      title: 'Contrat Mock 1323',
      contractCode: 'MOCK-C-1323',
      contractColor: '#697ace',
    },
    lot: {
      id: 27,
      lotNumber: 'Mock Lot 1603',
    },
    weeklySchedules: [
      {
        weekType: WeekType.ODD,
        periods: [
          {
            dayOfWeek: DaysOfWeek.FRIDAY,
            periodOfDay: PeriodOfDay.EVENING,
          },
        ],
      },
    ],
  };
  
  