import type { TableColumn } from "@/shared/types/common"
import { ExportTab, IExport, ExportFilesStatus } from "../types/export"

export const DEFAULT_EXPORT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "Job Id", type: "text", width: 80 },
  {
    id: "exportFilesStatus",
    label: "Statut",
    type: "select",
    width: 100,
    options: [
      { value: ExportFilesStatus.DONE, label: "Complété" },
      { value: ExportFilesStatus.IN_PROGRESS, label: "En cours" },
      { value: ExportFilesStatus.FAILED, label: "Échoué" }
    ]
  },
  { id: "description", label: "Module", type: "", width: 150 , isNotSortable: true},
  { id: "startTime", label: "Date début", type: "date", width: 150 },
  { id: "user", label: "Utilisateur", type: "text", width: 120 },
  { id: "filePath", label: "Nom du fichier", type: "text", width: 180 },
  {
    id: "downloaded",
    label: "Téléchargé",
    type: "select",
    width: 100,
    options: [
      { value: "true", label: "Oui" },
      { value: "false", label: "Non" }
    ]
  },
  { id: "downloadDate", label: "Date téléchargement", type: "date", width: 150 },
  { id: "fileSize", label: "Taille", type: "text", width: 100 },
  { id: "", label: "", width: 88 },
]

export const _EXPORT_OPTION_STATUT = [
  { value: ExportFilesStatus.DONE, label: "Complété" },
  { value: ExportFilesStatus.IN_PROGRESS, label: "En cours" },
  { value: ExportFilesStatus.FAILED, label: "Échoué" },
]

export const _exports: IExport[] = []
