import { INITIAL_ADDRESS, MOCK_ADDRESSES } from '.';
import { Representative } from '../types/passenger';
import {  IRepresentative, RelationType as UsagerRelationType } from '../types/usager';
import { RelationType } from '../types/passenger';
import { Civility } from '../types/common';
import { AddressType } from '../types/establishment';

export const _representatives: IRepresentative[] = [
  {
    id: '1',
    civilite: Civility.MM,
    firstName: 'Jean',
    lastName: 'Dupont',
    type: UsagerRelationType.PERE,
    parentFirstName: 'Marie',
    parentLastName: 'Dupont',
    address: MOCK_ADDRESSES[0],
    adresseEtablissement: MOCK_ADDRESSES[1],
    schedule: {
      pair: {
        Lundi: { all: true, ret: false },
        Mardi: { all: true, ret: false },
        Mercredi: { all: true, ret: false },
        Jeudi: { all: true, ret: false },
        Vendredi: { all: true, ret: false },
        Samedi: { all: false, ret: false },
        Dimanche: { all: false, ret: false },
      },
      impair: {
        Lundi: { all: true, ret: false },
        Mardi: { all: true, ret: false },
        Mercredi: { all: true, ret: false },
        Jeudi: { all: true, ret: false },
        Vendredi: { all: true, ret: false },
        Samedi: { all: false, ret: false },
        Dimanche: { all: false, ret: false },
      },
    },
    mobile: ['0123456789'],
    email: 'jean.dupont@email.com',
    circuit: 'Circuit A',
  },
];

export const INITIAL_REPRESENTATIVE_DATA: Representative = {
  id: '',
  firstName: '',
  lastName: '',
  email: '',
  civility: Civility.MM,
  type: null,
  parentalAuthorization: false,
  arrivalNotification: false,
  circuitId: '',
  circuitCode: '',
  contacts: [],
  addresses: [],
  addressDetails: '',
  transportSchedulesRepresentative: []
};