import {
  DriverRoadMapStatus,
  IAddRoadmap,
  IOldRoadmap,
  IRoadmap,
  ISubmittedRoadmap,
  RoadMapStatus,
  SubmittedRoadMapStatus,
} from '../types/driver';
import { TableColumn } from '../types/common';
import { _noms, _prenoms, ADRESSE, ETS_NAMES } from '.';
import { StatCardProps } from '../components/charts/roadmap-stats-cards';
import { faClipboardList, faUserTie } from '@fortawesome/free-solid-svg-icons';
import { nomsChauffeur } from './_geolocData';
import { useRoadMapStore } from '../api/stores/roadMapStore';
import { useEffect } from 'react';
import { PeriodType } from '../types/roadMap';

export const _ROADMAP_STATUS = [
  { value: RoadMapStatus.NotValid, label: 'Non valid' },
  { value: RoadMapStatus.Valid, label: 'Valid' },
];
export const _SUBMITTED_ROADMAP_STATUS = [
  { value: SubmittedRoadMapStatus.NotSubmitted, label: 'Non soumise' },
  { value: SubmittedRoadMapStatus.Submitted, label: 'Soumise ' },
];

export const _driversRoadmap = [...Array(50)].map((_, index) => {
  const date = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  return {
    id: (index + 1).toString(),
    nomChauffeur: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
    date: date.toISOString().split('T')[0],
    nombreHeures: (index + 1).toString(),
    statut: Object.values(RoadMapStatus)[index % 2],
    phone: `+33 6 12 34 56 78 ${index}`,
    email: 'test@gmail.com',
  };
});

export const _oldRoadmap = [...Array(50)].map((_, index) => {
  const date = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  return {
    id: (index + 1).toString(),
    driverName: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
    name: `Feuille de route Septembre 2024`,
    date: date.toISOString().split('T')[0],
    nombreHeures: (index + 1).toString(),
  };
});

export const DEFAULT_DRIVER_ROADMAP_TABLE_HEAD: TableColumn[] = [
  { id: 'nomChauffeur', label: 'Nom du chauffeur', type: 'text', align: 'left', width: 250 },
  { id: 'date', label: 'Date', type: 'date', align: 'left', width: 250 },
  { id: 'statut', label: 'Status', type: 'status', align: 'left', width: 250 },
  { id: 'nombreHeures', label: "Nombre d'heures", type: 'text', align: 'left', width: 250 },
  { id: 'contacter', label: 'Contacter', type: 'action', align: 'center', width: 60 },
  { id: 'anciennesListes', label: 'Anciennes listes', type: 'action', align: 'center', width: 60 },
];

export const DEFAULT_OLD_ROADMAPS_TABLE_HEAD: TableColumn[] = [
  {id:'driverName', label: 'Nom du chauffeur', type: 'text', align: 'left'},
  { id: 'name', label: 'Nom', type: 'text', align: 'left' },
  { id: 'date', label: 'Date', type: 'date', align: 'left' },
  { id: 'nombreHeures', label: "Nombre d'heures", type: 'text', align: 'left' },
  { id: '', label: 'Actions' },
];

export const INITIAL_DRIVER_ROADMAP_DATA: IRoadmap = {
  id: '',
  nomChauffeur: '',
  date: '',
  nombreHeures: '',
  statut: RoadMapStatus.NotValid,
  phone: '',
  email: '',
};

export const INITIAL_OLD_ROADMAPS_DATA: IOldRoadmap = {
  id: '',
  name: '',
  driverName: '',
  date: '',
  nombreHeures: '',
};

const generateTimeRange = (hour: number) => {
  const start = `${hour}:00`;
  const end = `${hour}:30`;
  return `${start} - ${end}`;
};
export const _driverScheduleList = [...Array(5)].map((_, index) => {
  const date = new Date(2002 + Math.floor(index / 12), 10, (index % 28) + 1);
  return {
    id: (index + 1).toString(),
    date: date.toISOString().split('T')[0],
    matin: '',
    midi: '',
    apresMidi: '',
    soir: '',
  };
});

export const DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD: TableColumn[] = [
  { id: 'date', label: 'Jour', type: 'date', align: 'center' },
  { id: 'matin', label: 'Matin', type: 'text', align: 'center' },
  { id: 'midi', label: 'Midi', type: 'text', align: 'center' },
  { id: 'apresMidi', label: 'Après-midi', type: 'time', align: 'center' },
  { id: 'soir', label: 'Soir', type: 'time', align: 'center' },
  { id: 'action', label: '', align: 'center' },
];

export const DEFAULT_GEOLOCATION_TABLE_HEAD: TableColumn[] = [
  { id: 'date', label: 'Jour', type: 'date', align: 'center' },
  { id: 'matin', label: 'Matin', type: 'text', align: 'center' },
  { id: 'midi', label: 'Midi', type: 'text', align: 'center' },
  { id: 'apresMidi', label: 'Après-midi', type: 'time', align: 'center' },
  { id: 'soir', label: 'Soir', type: 'time', align: 'center' },
];

export const _geolocationList = [...Array(5)].map((_, index) => {
  const date = new Date(2025, 6, index + 1); // July 2025 dates
  return {
    id: (index + 1).toString(),
    date: date.toISOString().split('T')[0],
    matin: `08:00 - 09:30`,
    midi: `12:00 - 13:00`,
    apresMidi: `15:00 - 16:30`,
    soir: `19:00 - 20:00`,
  };
});

const TITLES = [
  'Transport scolaire pour le mois de novembre',
  'Transport scolaire pour le mois de septembre',
  'Transport scolaire pour le mois de decembre',
];

const DESCRIPTIONS = [
  'Véhicule VSN89364 – départ à 07h00 avec chargement prioritaire',
  'Tournée matinale avec 2 arrêts – chauffeur à confirmer',
  'Livraison de matériel informatique – prévoir badge d’accès',
];

export const DEFAULT_NEW_ROADMAP_TABLE_HEAD: TableColumn[] = [
  { id: 'title', label: "Titre d'envoie", type: 'text' },
  { id: 'driversCount', label: 'Nombre de chauffeur', type: 'text', width: 180 },
  { id: 'sendDate', label: "Date d'envoie", type: 'date', width: 180 },
  { id: 'planningType', label:"fréquence", type: 'text' },
  { id: 'agentName', label: 'Envoyer par', type: 'text' },
];

const VEHICLES = ['VSN89364', 'KHT89364', 'LMP74521', 'WXY45678'];

export const _AddNewRoadmap = [...Array(50)].map((_, index) => {
  const date = new Date(2002 + Math.floor(index / 12), 10, (index % 28) + 1);
  return {
    id: (index + 1).toString(),
    title: TITLES[index % TITLES.length],
    nbrDriver: (index + 1).toString(),
    sendDate: date.toISOString().split('T')[0],
    description: DESCRIPTIONS[index % DESCRIPTIONS.length],
    sender: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
  };
});
export const INITIAL_NEW_ROADMAP_DATA: IAddRoadmap = {
  id: '',
  title: '',
  nbrDriver: '',
  sendDate: '',
  sender: '',
};

export const DEFAULT_SUBMITTED_ROADMAP_TABLE_HEAD: TableColumn[] = [
  { id: 'driverName', label: 'Nom du chauffeur', type: 'text', align: 'center' },
  { id: 'date', label: 'Date', type: 'none', align: 'center' },
  { id: 'departementName', label: 'Département', type: 'text', align: 'center' },
  {
    id: 'isSubmitted',
    label: 'Statut',
    type: 'select',
    options: [
      { label: 'Soumise', value: 'true' },
      { label: 'Non soumise', value: 'false' },
    ],
   align: 'left',
  },
  { id: 'contacter', label: 'Contacter', type: 'action', align: 'center' },
  { id: 'action', label: 'Actions', type: 'action', align: 'center' },
];
export const _SubmittedRoadmap = [...Array(25)].map((_, index) => {
  const date = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  return {
    id: (index + 1).toString(),
    driverName: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
    departement: ETS_NAMES[index % ETS_NAMES.length],
    status: Object.values(SubmittedRoadMapStatus)[index % 2],
    date: date.toISOString().split('T')[0],
    nombreHeures: (index + 1).toString(),
    phone: `+33 6 12 34 56 78 ${index}`,
    email: 'test@gmail.com',
  };
});

export const INITIAL_SUBMUITTED_ROADMAP_DATA: ISubmittedRoadmap = {
  id: '',
  driverName: '',
  departement: '',
  status: '',
  date: '',
  nombreHeures: '',
  phone: '',
  email: '',
};
export const geolocPeriodRoutes = [
  {
    label: 'Matin',
    timeRange: '06:00 – 11:59',
    routes: [
      {
        startTime: '07:09:18',
        endTime: '08:16:50',
        departure: 'Avenue Hassan II, Casablanca',
        destination: 'Boulevard Mohammed V, Rabat',
      },
      {
        startTime: '08:22:40',
        endTime: '08:44:20',
        departure: 'Rue des Fleurs, Casablanca',
        destination: 'Avenue des FAR, Rabat',
      },
    ],
  },
  {
    label: 'Midi',
    timeRange: '12:00 – 13:59',
    routes: [],
  },
  {
    label: 'Après-midi',
    timeRange: '14:00 – 17:59',
    routes: [
      {
        startTime: '15:17:00',
        endTime: '15:24:08',
        departure: 'Avenue Allal El Fassi, Rabat',
        destination: 'Boulevard Zerktouni, Fès',
      },
      {
        startTime: '15:26:48',
        endTime: '15:51:58',
        departure: 'Rue de Marrakech, Rabat',
        destination: 'Avenue Moulay Youssef, Fès',
      },
    ],
  },
  {
    label: 'Soir',
    timeRange: '18:00 – 23:59',
    routes: [],
  },
];

export const planningVsnRoutes = [
  {
    startHour: '08:00',
    endHour: '10:00',
    departure: 'Casablanca',
    destination: 'Rabat',
    periodTime: PeriodType.Matin,
  },
  {
    startHour: '14:00',
    endHour: '16:00',
    departure: 'Rabat',
    destination: 'Fès',
    periodTime: PeriodType.Midi,
  },
  {
    startHour: '14:00',
    endHour: '16:00',
    departure: 'Rabat',
    destination: 'Fès',
    periodTime: PeriodType.Soir,
  },
  {
    startHour: '14:00',
    endHour: '16:00',
    departure: 'Rabat',
    destination: 'Fès',
    periodTime: PeriodType.ApresMidi,
  },
];
