import { RoleStatus } from "../api/stores/roleStore";
import { TableColumn } from "../types/common";
import { IRole } from "../types/role";
import { StatusOption } from "@/shared/components/table/StatusMenu";


export const ROLE_STATUS: StatusOption[] = [
  { 
    value: RoleStatus.ENABLED, 
    label: 'Actif',
    color: 'rgb(34, 154, 22)',
    backgroundColor: 'rgba(84, 214, 44, 0.16)'
  },
  { 
    value: RoleStatus.DISABLED, 
    label: 'Inactif',
    color: 'rgb(183, 33, 54)',
    backgroundColor: 'rgba(255, 72, 66, 0.16)'
  },
];

export const DEFAULT_ROLE_TABLE_HEAD: TableColumn[] = [
  { id: '', label: '' },
  { id: 'id', label: 'ID', type: 'text' },
  { id: 'name', label: 'Nom du rôle', type: 'text' },
  { id: 'modules', label: 'Modules', type: 'modules' },
  { id: 'createdAt', label: 'Date de création', type: 'date' },
  { id: 'status', label: 'Statut', type: 'status' },

  { id: '', label: 'Actions' },
];

export const ROLE_PERMISSIONS = [
  { value: 'lire', label: 'Lire' },
  { value: 'ecrire', label: 'Écrire' },
  { value: 'modifier', label: 'Modifier' },
  { value: 'supprimer', label: 'Supprimer' },
];


export const INITIAL_ROLE_DATA: IRole = {
  id: '',
  name: '',
  description: '',
  createdAt: new Date().toISOString().split('T')[0],
  status: RoleStatus.ENABLED,
  modules: []
};