import { TableColumn } from "../types/common";
import { ISession } from "../types/session";

// ----------------------------------------------------------------------


export const DEFAULT_TABLE_HEAD: TableColumn[] = [
  { id: 'device', label: 'Appareil', type: 'text'},
  { id: 'location', label: 'Lieu', type: 'text' },
  { id: 'lastUsed', label: 'Dernière utilisation', type: 'date' },
  { id: 'timeAgo', label: 'Il y a', type: 'text' },
  { id: '', label: 'Action'},
];

const browsers = ['Chrome', 'Firefox', 'Safari', 'Edge'];
const deviceTypes = ['mac', 'windows', 'mobile', 'tablet', 'other'] as const;
const locations = ['Paris, France', 'Lyon, France', 'Marseille, France', 'Bordeaux, France'];

export const _sessions: ISession[] = Array.from({ length: 5 }).map((_, index) => ({
  id: `session_${index + 1}`,
  device: {
    type: deviceTypes[Math.floor(Math.random() * deviceTypes.length)],
    browser: browsers[Math.floor(Math.random() * browsers.length)],
  },
  location: locations[Math.floor(Math.random() * locations.length)],
  lastUsed: new Date().toISOString(),
  lastUsedDate: new Date(Date.now() - Math.floor(Math.random() * 7 * 24 * 60 * 60 * 1000)),
  isCurrent: index === 0,
}));

export const INITIAL_SESSION_DATA: ISession = {
  id: '',
  device: {
    type: 'other',
    browser: '',
  },
  location: '',
  lastUsed: '',
  lastUsedDate: new Date(),
  isCurrent: false,
};

export default _sessions;