import { INITIAL_ADDRESS } from ".";
import { Etat, Sens } from "../types/circuit";
import { TableColumn } from "../types/common";
import { BinaryQuestion, EtatTrajet, IAddPoint, ISuiviTrajet, ITrajet, TypeTrajet } from "../types/trajet";

export const _TRAJET_ETAT = [
  { value: "controle", label: "Contrôlé" },
  { value: "non_controle", label: "Non Contrôlé" },
  { value: "modifie", label: "Modifié" },
];
export const _BINARY_Qst = [
  { value: "oui", label: "Oui" },
  { value: "non", label: "Non" },
];

export const _OPTION_VEHICULE = [
  { value: Sens.Retour, label: "Bus" },
  { value: Sens.Retour, label: "Mini-Bus" },
  { value: Sens.Retour, label: "Berline" },
  { value: Sens.Retour, label: "Abarth" },
];


export const _TRAJET_TYPE = [
  { value: TypeTrajet.personnalise, label: "Trajet personnalisé" },
  { value: TypeTrajet.Normal, label: "Trajet normal" },
];
export const getTrajetType = (status: string): string => {
  const statusObj = _TRAJET_TYPE.find(s => s.value === status);
  return statusObj ? statusObj.label : "Inconnu";
};

  export const getTrajetEtat = (status: string): string => {
    const statusObj = _TRAJET_ETAT.find(s => s.value === status);
    return statusObj ? statusObj.label : "Inconnu";
  };


export const _trajets = [...Array(50)].map((_, index) => {
  const trajetDate = new Date(2024, Math.floor(index % 12), Math.floor((index % 28) + 1));
  const joursTrajet = ["Lun-Mar 18h", "Mar 17h", "Jeu-Ven 18h", "Mer-Ven 17h"][index % 4];
  const chauffeurNames = ["Ahmed Benomar", "Khalid Larbi", "Sara Amrani", "Hassan Moussa"];
  const vehicleTypes = ["Bus", "Mini-Bus", "Berline", "vehicule"];
  const clients = ["École Futur", "Groupe Alpha", "Entreprise Soleil", "Lycée Elites"];
  const randomValue = Math.random();

  return {
    id: (index + 1).toString(),
    dateDebut: trajetDate.toISOString().split('T')[0],
    intitule: joursTrajet,
    sensAR: index < 2  ? Sens.Aller : Sens.Retour,
    rotation:index < 2  ? BinaryQuestion.Oui : BinaryQuestion.Non,
    nombreUsagers: Math.floor(randomValue * 50) + 1,
    nombreEtablissements: Math.floor(randomValue * 5) + 1,
    etat: Object.values(EtatTrajet)[Math.floor(randomValue * Object.values(EtatTrajet).length)],
    chauffeur: index % 2 === 0 ? chauffeurNames[index % chauffeurNames.length] : "Non Affecté",
    vehicule: vehicleTypes[index % vehicleTypes.length],
    peages:index < 2  ? BinaryQuestion.Oui : BinaryQuestion.Non,
    societe: "Adanev",
    client: clients[index % clients.length],
    typeTrajet:randomValue < 0.4  ? TypeTrajet.Normal : TypeTrajet.personnalise,
    isActive: randomValue < 0.3,
  };
});

export const DEFAULT_TRAJET_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N° Trajet', type: 'text', align: 'left' },
  { id: 'startDate', label: 'Date de Début', type: 'date', align: 'center' },
  { id: 'tripTitle', label: 'Intitulé', type: 'text', align: 'left' },
  { id: 'tripDirection', label: 'Sens', type: 'status', align: 'left' },
  { id: 'isRotation', label: 'Rotation', type: 'status', align: 'center' },
  { id: 'numberOfPassengers', label: 'Nbr Usagers', type: '', align: 'center' , isNotSortable: false},
  { id: 'numberOfEstablishments', label: 'Nbr Établissements', type: '', align: 'center' , isNotSortable: false },
  { id: 'circuitState', label: 'État', type: '', align: 'center' , isNotSortable: false  },
  { id: 'hasTolls', label: 'Péages inclus', type: 'status', align: 'center' },
  { id: 'agencyName', label: 'Société', type: '', align: 'left' ,  isNotSortable: false},
  { id: 'client', label: 'Client', type: '', align: 'left' , isNotSortable: false},
  { id: 'tripType', label: 'Type', type: 'status', align: 'center' },
  { id: 'createdAt', label: 'Créé le', type: 'date', align: 'center' },
  { id: 'isActive', label: 'Active', type: 'boolean', align: 'center' },
  { id: '', label: 'Action' },


];

export const INITIAL_TRAJET_DATA: ITrajet = {
  id: '',
  dateDebut: '',
  intitule: '',
  sensAR: Sens.Aller,
  rotation: BinaryQuestion.Non,
  nombreUsagers: 0,
  nombreEtablissements: 0,
  etat: EtatTrajet.NonControle,
  vehicule: '',
  peages:BinaryQuestion.Non,
  societe: 'Adanev',
  client: '',
  typeTrajet: TypeTrajet.Normal,
  isActive: false,
};

export const _suiviTrajet: ISuiviTrajet[] = [...Array(4)].map((_, index) => {
  const condition = Math.random() < 0.4;

  // Define proper GPS coordinates for Marseille area
  const marseilleCoordinates = [
    { lat: 43.2963, lng: 5.3796 }, // Start point
    { lat: 43.2965, lng: 5.3780 }, // Point 1
    { lat: 43.2960, lng: 5.3765 }, // Point 2
    { lat: 43.2950, lng: 5.3770 }  // End point
  ];

  const coords = marseilleCoordinates[index] || marseilleCoordinates[0];

  return {
    id: (index + 1).toString(),
    tripId: `trip-${index + 1}`,
    nom: condition ? "Passage Éveil" : "Route Sérénité",
    adresse: condition ? "Groupe Alpha, 31 Rue Savoir" : "École Clair, 3 Rue Savoir",
    horaire: "10:00",
    km: "10:50",
    tps: "12003",
    gps: coords.lat.toString(),
    gps1: coords.lng.toString(),
    gps2: "0",
  };
});

export const DEFAULT_SUIVIT_TRAJET_TABLE_HEAD: TableColumn[] = [
    { id: "id", label: "N° trajet", align: "left" as const },
    { id: "nom", label: "Nom & adresse", align: "left" as const },
    { id: "horaire", label: "Horaire", align: "center" as const },
    { id: "km", label: "Km", align: "center" as const },
    { id: "tps", label: "Tps (sec)", align: "center" as const },
    { id: "gps", label: "Gps", align: "center" as const },
  ]

export const INITIAL_ADD_POINT_DATA: IAddPoint = {
  titleEndPoint: '',
  endPointAddress: INITIAL_ADDRESS,
  passengerId: '',
  establishment: '',
  establishmentId: 0,
  };
