import { TableColumn } from '../types/common';
import { IValidRoadmap } from '../types/driver';
import { _noms, _prenoms } from '.';

const randomNumber = (min: number, max: number) => {

    return Math.floor(Math.random() * (max - min + 1) + min)
  }
  
  const formatTime = (hours: number) => {
    const h = Math.floor(hours)
    const m = Math.round((hours - h) * 60)
    return `${h.toString().padStart(2, "0")}:${m.toString().padStart(2, "0")}`
  }
  
  export const _validRoadmapData = [...Array(50)].map((_, index) => {
    const totalDay = randomNumber(6, 12)
    const totalInHundredths = (totalDay * 100)
    const deductionOrVacation = formatTime(randomNumber(0, 2) + randomNumber(0, 99) / 100)
    const hoursPaidInHundredths = ((totalDay - Number.parseFloat(deductionOrVacation)) * 100)
    const deltaFixedPackageDeduction = formatTime(randomNumber(0, 1) + randomNumber(0, 99) / 100)
    const packageValue = formatTime(randomNumber(6, 8) + randomNumber(0, 99) / 100)
    const nightHours = formatTime(randomNumber(0, 3) + randomNumber(0, 99) / 100)
    const waitingHours = formatTime(randomNumber(0, 2) + randomNumber(0, 99) / 100)
    const numberOfVacations = randomNumber(0, 5)
  
    return {
      id: (index + 1).toString(),
      date: new Date(2025, 0, index + 1).toISOString().split('T')[0], 
      driverId : index+1,
      driverName: `${_prenoms[index % _prenoms.length]} ${_noms[index % _noms.length]}`,
      totalJournee: totalDay,
      totalCentieme: totalInHundredths,
      deduction: deductionOrVacation,
      paidHoursCentieme: hoursPaidInHundredths,
      delta: deltaFixedPackageDeduction,
      forfait: packageValue,
      nightHours: nightHours,
      waitingHours: waitingHours,
      numberVacations: numberOfVacations,
  } as IValidRoadmap
})

export const DEFAULT_VALID_ROADMAP_TABLE_HEAD: TableColumn[] = [
      { id: "date", label: "Date", type: "dateRoadMap", align: "center" },
    { id: "driverName", label: "Nom du chauffeur", type: "text" },
    { id: 'departementName', label: 'Département', type: 'text', align: 'left' },
    { id: "totalJournee", label: "Total journée", type: "", align: "center" },
    { id: "totalCentieme", label: "Total en centième", type: "", align: "center" },
    { id: "deduction", label: "Déduction ou vacation", type: "", align: "center" },
    { id: "paidHoursCentieme", label: "Heures payées en centième", type: "", align: "center" },
    { id: "delta", label: "Delta forfait fixe-deduc", type: "", align: "center" },
    { id: "forfait", label: "Forfait", type: "", align: "center" },
    { id: "nightHours", label: "Heures de nuit", type: "", align: "center" },
    { id: "waitingHours", label: "Heures d'attente", type: "", align: "center" },
    { id: "numberVacations", label: "Nb de vacation", type: "", align: "center" },
    { id: 'anciennesListes', label: 'Anciennes listes', type: 'action', align: 'center' },
  ]

export const INITIAL_VALID_ROADMAP: IValidRoadmap = {
    id: "",
    date: "",
    driverId: 0,
    driverName: "",
    totalJournee:0,
    totalCentieme: 0,
    deduction: "",
    paidHoursCentieme: 0,
    delta: "",
    forfait: "",
    nightHours: "",
    waitingHours: "",
    numberVacations: 0,
  }

export const DEFAULT_TOTAL_HOUR_RESULT_HEAD: TableColumn[] = [
  { id: 'totalDay', label: 'Total journée', type: 'number', align: 'center' },
  { id: 'totalCentieme', label: 'Total en centième', type: 'number', align: 'center' },
  { id: 'deduction', label: 'Déduction ou vacation', type: 'number', align: 'center' },
  { id: 'paidHoursCentieme', label: 'Heures payées en centième', type: 'number', align: 'center' },
  { id: 'delta', label: 'Delta forfait fixe-deduc', type: 'number', align: 'center' },
  { id: 'forfait', label: 'Forfait', type: 'number', align: 'center' },
  { id: 'nightHours', label: 'Heures de nuit', type: 'number', align: 'center' },
  { id: 'waitingHours', label: "Heures d'attente", type: 'number', align: 'center' },
  { id: 'numberVacations', label: 'Nb de vacation', type: 'number', align: 'center' },
];

