import type { TableColumn } from '@/shared/types/common';
import { IIncident, IncidentStatus, TypeDeclaration } from '@/shared/types/flottes/incident';
import { _CHAUFFEURS } from '../_absenceDriver';
import { IMMATRICULATIONS } from '..';
import { DEPARTEMENT_OPTIONS } from '@/shared/sections/establishment/attendance/utils/form-fields-attendance';
import { _interventions } from './_supplier';
import { InterventionType } from '@/shared/types/flottes/vehicule';

export const _INCIDENT_STATUS_OPTIONS = [
  { label: 'En cours', value: IncidentStatus.InProgress },
  { label: 'Résolu', value: IncidentStatus.Resolved },
  { label: 'En attente de pièces', value: IncidentStatus.WaitingForParts },
  { label: 'En réparation', value: IncidentStatus.Repair },
];

const DECLARATION_OPTIONS = ['axa', 'adanev'];
const SUPPLIERS = ['Garage Martin', 'Carrosserie Duval', 'Assistance Plus', 'Remorquage Sud'];
const RESPONSIBILITIES = ['conducteur', 'tiers', 'partagée', 'inconnue'];

export const _incidents: IIncident[] = [...Array(30)].map((_, i) => {
  const id = `${(i + 1).toString().padStart(6, '0')}`;
  const date = new Date(2025, Math.floor(i / 6), 3 + (i % 28)).toISOString().split('T')[0];
  const intervention = Math.random() < 0.5;
  return {
    id,
    department: DEPARTEMENT_OPTIONS[i % DEPARTEMENT_OPTIONS.length].label,
    date,
    vehicle: IMMATRICULATIONS[i % IMMATRICULATIONS.length],
    driver: _CHAUFFEURS[i % _CHAUFFEURS.length],
    damages: intervention ? 'Pare-chocs avant endommagé' : 'Aucun dégât apparent',
    circumstances: i % 2 === 0 ? 'Collision à un carrefour' : 'Stationnement incorrect',
    responsibility: RESPONSIBILITIES[i % RESPONSIBILITIES.length],
    declaration: DECLARATION_OPTIONS[i % DECLARATION_OPTIONS.length] as TypeDeclaration,
    interventionType: _interventions[i % _interventions.length].typeIntervention,
    intervention: _interventions[i % _interventions.length].nomIntervention,
    supplier: intervention ? SUPPLIERS[i % SUPPLIERS.length] : '',
    amount: intervention ? Math.floor(Math.random() * 2000) + 100 : 0,
    status: _INCIDENT_STATUS_OPTIONS[i % _INCIDENT_STATUS_OPTIONS.length].value as IncidentStatus,
    isActive: Math.random() < 0.8,
  };
});

export const DEFAULT_INCIDENT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N°', type: 'text' },
  { id: 'department', label: 'Département', type: 'text' },
  { id: 'date', label: 'Date', type: 'date' },
  { id: 'vehicle', label: 'Véhicule', type: 'text' },
  { id: 'driver', label: 'Conducteur', type: 'text' },
  { id: 'declaration', label: 'Déclaration', type: 'text' },
  { id: 'status', label: 'Statut', type: 'statut' },
  { id: 'isActive', label: 'Actif', type: 'boolean', align: 'center' },
  { id: '', label: 'Action' },
];

export const INITIAL_VEHICLE_INCIDENT_DATAINITIAL_INCIDENT_DATA: IIncident = {
  id: '',
  vehicle: '',
  department: '',
  date: '',
  driver: '',
  damages: '',
  circumstances: '',
  responsibility: '',
  declaration: TypeDeclaration.Axa,
  intervention: '',
  interventionType: InterventionType.Entretien,
  supplier: '',
  status: IncidentStatus.InProgress,
  isActive: true,
};
