import { TableColumn } from "@/shared/types/common";
import { _OPTION_STATUT } from "./_intervention";
import { _CHAUFFEURS } from "../_absenceDriver";
import { AssignmentHistory, ICircuitDriverAssignment, IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation";
import { _vehicles } from "./_vehicle";

export const _vehicleAffectations: IVehicleAffectation[] = [...Array(40)].map((_, i) => {
  return {
    id: (i+1).toString(),
    secteur: `Secteur ${i%5+1}`,
    dateAttribution: `2024-06-${(i%28+1).toString().padStart(2,'0')}`,
    endAttributionDate: `2024-07-${(i%28+1).toString().padStart(2,'0')}`,
    numeroImmatriculation: `ABC-12${i%10}${i%10}`,
    personnelType: i%2 === 0 ? "chauffeur" : "sedentaire",
    nomPersonnel: i%2 === 0 ? _CHAUFFEURS[i % _CHAUFFEURS.length] : `Sedentaire ${i}`,
    fournisseurCarteCarburant: `Fournisseur ${i%3+1}`,
    numeroCarteCarburant: `CC${1000+i}`,
    numeroLicence: `LIC${2000+i}`,
    transcolaire: i%2 === 0 ? "ok" : "",
    fleet: i%2 === 0 ? "ok" : "",
    monday: i%2 === 1 ? "ok" : "",
    typeVehicule: i%2 === 0 ? "5 places" : "7 places",
    dateRestitution: `2024-07-${(i%28+1).toString().padStart(2,'0')}`,
    isActive: false,
  }
});


export const DEFAULT_AFFECTAITON_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text', align: 'center' },
  { id: 'secteur', label: 'Secteur', type: 'text' },
  { id: 'dateAttribution', label: 'Date d’attribution', type: 'date', align: 'center' },
  { id: 'endAttributionDate', label: 'Date de fin d\'attribution', type: 'date', align: 'center' },
  { id: 'numeroImmatriculation', label: 'Immatriculation', type: 'text' },
  { id: 'personnelType', label: 'Personnel', type: 'text' },
  { id: 'nomPersonnel', label: 'Nom personnel', type: 'text' },
  { id: 'fournisseurCarteCarburant', label: 'Fournisseur carte carburant', type: 'text' },
  { id: 'numeroCarteCarburant', label: 'Carte carburant', type: 'text' },
  { id: 'numeroLicence', label: 'Numéro de licence', type: 'text' },
  { id: 'transcolaire', label: 'Transcolaire', type: 'text', align: 'center' },
  { id: 'fleet', label: 'Fleet', type: 'text' },
  { id: 'monday', label: 'Monday', type: 'text', align: 'center' },
  { id: 'dateRestitution', label: 'Date de restitution', type: 'date', align: 'center' },
  { id: 'typeVehicule', label: 'Type de véhicule', type: 'text' },
  { id: '', label: 'Action' },
];

export const INITIAL_AFFECTATION_DATA: IVehicleAffectation = {
  id: '',
  secteur: '',
  dateAttribution: '',
  endAttributionDate: '',
  numeroImmatriculation: '',
  typeVehicule: '',
  personnelType: '',
  nomPersonnel: '',
  fournisseurCarteCarburant: '',
  numeroCarteCarburant: '',
  numeroLicence: '',
  transcolaire: '',
  fleet: '',
  monday: '',
  dateRestitution: '',
  isActive: false,
}

export const _circuitDriverAssignments: ICircuitDriverAssignment[] = [...Array(3)].map((_, i) => {
  return {
    id: (i+1).toString(),
    driverName: `Chauffeur ${i+1}`,
    assignmentDate: `2024-06-${(i%28+1).toString().padStart(2,'0')}`,
    circuitCode: `CIR${1000+i}`,
  }
});

export const DEFAULT_CIRCUIT_DRIVER_ASSIGNMENT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'driverName', label: 'Nom du chauffeur', type: 'text' },
  { id: 'circuitCode', label: 'Code du circuit', type: 'text' },
  { id: 'assignmentDate', label: 'Date d’attribution', type: 'date' },
];

export const DEFAULT_HISTORY_ASSIGNMENT_TABLE_HEAD = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'secteur', label: 'Secteur', type: 'text' },
  { id: 'typeVehicule', label: 'Type de véhicule', type: 'text' },
  { id: 'numeroImmatriculation', label: 'Immatriculation', type: 'text' },
  { id: 'dateAttribution', label: "Date d'attribution", type: 'date' },
  { id: 'endAttributionDate', label: 'Date de fin d\'attribution', type: 'date' },
  { id: 'dateRestitution', label: 'Date de restitution', type: 'date' },
];

export const _historyAssignments: AssignmentHistory[] = [
  {
    id: '1',
    secteur: 'Secteur 5',
    typeVehicule: '7 places',
    numeroImmatriculation: 'ABC-1299',
    dateAttribution: '10/06/2024',
    endAttributionDate: '10/07/2024',
    dateRestitution: '10/07/2024',
  },
  {
    id: '2',
    secteur: 'Secteur 2',
    typeVehicule: '4x4',
    numeroImmatriculation: 'XYZ-5678',
    dateAttribution: '01/05/2024',
    endAttributionDate: '01/06/2024',
    dateRestitution: '01/06/2024',
  },
];

export const INITIAL_HISTORY_ASSIGNMENT_DATA: AssignmentHistory = {
  id: '',
  secteur: '',
  typeVehicule: '',
  numeroImmatriculation: '',
  dateAttribution: '',
  endAttributionDate: '',
  dateRestitution: '',
};