import { IEmployee } from "@/shared/types/flottes/employee"
import { _noms, _petrolier, _prenoms, AGENCY, generateDateRange, generatePhoneNumber, generateStartDate, getDepartement, IMMATRICULATIONS } from ".."
import { format, subDays } from "date-fns";
import { Consumption } from "@/shared/types/flottes/consumption";
import { TableColumn } from "@/shared/types/common";
const ABNORMAL_REASONS = [
  "Consommation excessive",
  "Prise de carburant trop fréquente",
  "Volume inhabituel pour ce véhicule",
  "Station service non autorisée",
]

const TRANSACTION_ADDRESSES = [
  "Station Total - 123 Avenue de la République, 75011 Paris",
  "Shell Express - 45 Rue du Commerce, 69002 Lyon", 
  "DKV Station - 67 Boulevard des Invalides, 13001 Marseille",
  "BP Connect - 89 Route Nationale, 59000 Lille",
  "Esso Express - 12 Place de la Gare, 31000 Toulouse",
  "Total Access - 34 Avenue Jean Jaurès, 06000 Nice",
  "Shell - 56 Rue de la Paix, 67000 Strasbourg",
  "DKV - 78 Boulevard Voltaire, 33000 Bordeaux",
  "Total Relais - 90 Avenue Foch, 21000 Dijon",
  "BP Station - 15 Rue Gambetta, 49000 Angers"
]

const CONSUMPTION_DETAILS = [
  "Ravitaillement durant un trajet longue distance pour livraison urgente",
  "Plein effectué en dehors des heures habituelles en raison d'une mission exceptionnelle",
  "Consommation lors d'une tournée étendue dans plusieurs départements",
  "Ravitaillement d'urgence suite à une panne de véhicule de remplacement",
  "Plein réalisé lors d'un détour imprévu pour éviter des travaux routiers",
  "Consommation supplémentaire due à des conditions météorologiques difficiles",
  "Ravitaillement lors d'une mission de dépannage en urgence",
  "Plein effectué lors d'un transport exceptionnel nécessitant un véhicule plus lourd",
  "Consommation lors d'une formation conduite en conditions réelles",
  "Ravitaillement suite à un changement de planning de dernière minute"
]

export const createMockEmployee = (index: number): IEmployee => {
    return {
      id: `EMP${index + 1}`,
      gender: index % 2 === 0 ? "M" : "F",
      firstName: _prenoms[index % _prenoms.length],
      lastName: _noms[index % _noms.length],
      circuit: `Circuit ${index + 1}`,
      address: `${index + 1} Rue de la Paix`,
      zipCode: `7500${index % 10}`,
      city: AGENCY[index % AGENCY.length],
      phone: generatePhoneNumber("+33"),
      email: `${_prenoms[index % _prenoms.length].toLowerCase()}.${_noms[index % _noms.length].toLowerCase()}@example.com`,
      birthdate: format(subDays(new Date(), 10000 + index * 100), "yyyy-MM-dd"),
      department: getDepartement(index),
      activity: `Activity ${(index % 3) + 1}`,
      lastCardNumber: `CARD${1000 + index}`,
      lastTanker: _petrolier[index % _petrolier.length],
      dateOfEntry: format(subDays(new Date(), 1000 + index * 10), "yyyy-MM-dd"),
      fuelTypeCard: index % 2 === 0 ? "Diesel" : "Essence",
      vehicule: IMMATRICULATIONS[index % IMMATRICULATIONS.length],
      fuelVolume: 50 + index * 2,
      agencyCode: `AG${index % 10}`,
      fuelCard: null,
      consumptions: null,
      geolocData: null,
      lastNameFirstName: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
      errors: "",
      dateImported: format(subDays(new Date(), index), "yyyy-MM-dd"),
      totalEmailsSent: index,
      totalKilometersTraveled: 1000 + index * 100,
      totalFuelCost: 500 + index * 50,
      carRegistration: IMMATRICULATIONS[index % IMMATRICULATIONS.length],
      emailHistory: null,
      transcolaire: null,
      correctData: true,
    }
  }

  export const _consumptionMockList: Consumption[] = [...Array(20)].map((_, index) => {
    const isNormal = index % 3 !== 0
    const employee = createMockEmployee(index)
  
    return {
      id: (index + 1).toString(),
      employe: employee,
      tanker: _petrolier[index % _petrolier.length],
      date: generateStartDate(index),
      product: index % 2 === 0 ? "Diesel" : "Essence",
      quantity: 40 + index * 1.5,
      totalAmount: (40 + index * 1.5) * (1.8 + index * 0.02),
      puTTC: 1.8 + index * 0.02,
      zipCode: `7500${index % 10}`,
      city: AGENCY[index % AGENCY.length],
      normalConsumption: isNormal,
      fuelCardNumber: `CARD${1000 + index}`,
      causes: isNormal ? undefined : ABNORMAL_REASONS[index % ABNORMAL_REASONS.length],
      observation: isNormal ? undefined : `Observation ${index}`,
      sendMail: !isNormal,
      justification: isNormal ? undefined : `Justification ${index}`,
      managed: index % 4 === 0,
      // New fields for the consumption table columns
      cardNumber: `CARD${1000 + index}`,
      driverName: `${employee.firstName} ${employee.lastName}`,
      transactionDate: generateStartDate(index),
      vehicle: employee.carRegistration,
      fuelType: employee.fuelTypeCard,
      amount: `${((40 + index * 1.5) * (1.8 + index * 0.02)).toFixed(2)} €`,
      telephone: employee.phone,
      department: employee.department,
      // New fields for consumption details
      transactionAddress: TRANSACTION_ADDRESSES[index % TRANSACTION_ADDRESSES.length],
      consumptionDetails: CONSUMPTION_DETAILS[index % CONSUMPTION_DETAILS.length],
    }
  })

  export const INITIAL_CONSUMPTION_DATA: Consumption = {
    id: "",
    employe: {
      id: "",
      gender: "",
      firstName: "",
      lastName: "",
      circuit: "",
      address: "",
      zipCode: "",
      city: "",
      phone: "",
      email: "",
      birthdate: "",
      department: "",
      activity: "",
      lastCardNumber: "",
      lastTanker: "",
      dateOfEntry: "",
      fuelTypeCard: "",
      vehicule: "",
      fuelVolume: 0,
      agencyCode: "",
      fuelCard: null,
      consumptions: null,
      geolocData: null,
      lastNameFirstName: null,
      errors: "",
      dateImported: "",
      totalEmailsSent: 0,
      totalKilometersTraveled: 0,
      totalFuelCost: 0,
      carRegistration: "",
      emailHistory: null,
      transcolaire: null,
      correctData: true,
    },
    tanker: "",
    date: "",
    product: "",
    quantity: 0,
    totalAmount: 0,
    puTTC: 0,
    zipCode: "",
    city: "",
    normalConsumption: true,
    fuelCardNumber: "",
    sendMail: false,
    managed: false,
    // New fields
    cardNumber: "",
    driverName: "",
    transactionDate: "",
    vehicle: "",
    fuelType: "",
    amount: "",
    telephone: "",
    department: "",
    // New fields for consumption details
    transactionAddress: "",
    consumptionDetails: "",
  }

  export const CONSUMPTION_TABLE_HEAD: TableColumn[] = [
    { id: 'cardNumber', label: 'Numéro de carte', type: 'text' }, // Identifiant de la carte carburant du pétrolier
    { id: 'driverName', label: 'Nom du conducteur', type: 'text' }, // Nom complet du conducteur
    { id: 'transactionDate', label: 'Date de transaction', type: 'date' }, // Date de la consommation anormale
    { id: 'vehicle', label: 'Véhicule', type: 'text' }, // Immatriculation
    { id: 'tanker', label: 'Pétrolier', type: 'text' }, // Fournisseur
    { id: 'fuelType', label: 'Type de carburant', type: 'text' }, // Nature du carburant
    { id: 'amount', label: 'Montant de transaction', type: 'text' }, // Coût en euros
    { id: 'quantity', label: 'Quantité', type: 'text' }, // Volume en litres
    { id: 'telephone', label: 'Téléphone', type: 'text' }, // Contact du conducteur
    { id: 'department', label: 'Département', type: 'text' } 
  ]
  
  export const ALL_CONSUMPTIONS_TABLE_HEAD: TableColumn[] = [
    { id: 'employe', label: 'Chauffeur', type: 'text' },
    { id: 'fuelCardNumber', label: 'Carte carburant', type: 'text' },
    { id: 'tanker', label: 'Pétrolier', type: 'text' },
    { id: 'date', label: 'Date', type: 'date' },
    { id: 'department', label: 'Département', type: 'text' },
    { id: 'quantity', label: 'Quantité', type: 'number' },
    { id: 'puTTC', label: 'Prix unitaire', type: 'number' },
    { id: 'totalAmount', label: 'Total', type: 'number' },
    { id: 'statut', label: 'Statut', type: 'text' },
    { id: 'product', label: 'Produit', type: 'text' },
    { id: 'zipCode', label: 'Code postal', type: 'text' },
    { id: 'city', label: 'Ville', type: 'text' },
  ];
  