import type { TableColumn } from "@/shared/types/common"
import { type IFuelFee, FuelType } from "@/shared/types/flottes/fuelFee"
import { _CHAUFFEURS } from "../_absenceDriver"
import { _vehicles } from "./_vehicle"
import { ITankerType } from "@/shared/types/flottes/fuelImport"
import { _petrolier, generateStartDate } from ".."

export const _FUEL_TYPES = [FuelType.Diesel, FuelType.Essence, FuelType.Electrique, FuelType.Hybride]

export const _FUEL_TYPE_OPTIONS = [
  { value: FuelType.Diesel, label: "Diesel" },
  { value: FuelType.Essence, label: "Essence" },
  { value: FuelType.Electrique, label: "Électrique" },
  { value: FuelType.Hybride, label: "Hybride" },
]

export const _fuelFees: IFuelFee[] = [...Array(50)].map((_, i) => {
  const vehicle = _vehicles[i % _vehicles.length]
  const kmCompteur = 10000 + i * 500
  const kmParcourue = 50 + Math.floor(Math.random() * 200)
  const volumeCarburant = 20 + Math.floor(Math.random() * 50)
  const prix = 600 + Math.floor(Math.random() * 200)
  const total = volumeCarburant * prix

  return {
    id: `FC${(i + 1).toString().padStart(6, "0")}`,
    vehicule: vehicle.numeroImmatriculation,
    chauffeur: vehicle.chauffeur || _CHAUFFEURS[i % _CHAUFFEURS.length],
    date: generateStartDate(i),
    type: _FUEL_TYPES[i % _FUEL_TYPES.length],
    kmCompteur: kmCompteur.toString(),
    kmParcourue: kmParcourue.toString(),
    isActive: Math.random() < 0.8,
    departement: ["Logistique", "Commercial", "Technique"][i % 3],
    volumeCarburant,
    prix,
    total,
  }
})

export const DEFAULT_FUEL_FEE_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "Numéro", type: "text", width: 150 },
  { id: "vehicule", label: "Véhicule", type: "text", width: 150 },
  { id: "chauffeur", label: "Chauffeur", type: "text", width: 150 },
  { id: "date", label: "Date", type: "date", width: 120 },
  { id: "type", label: "Type", type: "text", width: 120 },
  { id: "departement", label: "Département", type: "text", width: 120 },
  { id: "kmCompteur", label: "Km compteur", type: "text", width: 120 },
  { id: "kmParcourue", label: "Km parcourue", type: "text", width: 120 },
  { id: "volumeCarburant", label: "Volume Carburant", type: "number", width: 100 },
  { id: "prix", label: "Prix", type: "number", width: 120 },
  { id: "total", label: "Total", type: "number", width: 140 },
  { id: "isActive", label: "Actif", type: "boolean", align: "center", width: 80 },
  { id: "", label: "Action", width: 100 },
]


export const INITIAL_FUEL_FEE_DATA: IFuelFee = {
  id: "",
  vehicule: "",
  chauffeur: "",
  date: "",
  type: FuelType.Diesel,
  kmCompteur: "",
  kmParcourue: "",
  isActive: true,
  departement: "",
  prix: 0,
  volumeCarburant: 0,
  total: 0
}

export const _TinkerTypes: ITankerType[] =  [
  {
    id: "1",
    typeTanker: _petrolier[0],
    type: FuelType.Diesel,
    isActive: true,
  },
  {
    id: "2",
    typeTanker: _petrolier[1],
    type: FuelType.Electrique,
    isActive: true,
  },
]

export const DEFAULT_TINKER_TYPE_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "supplierName", label: "Pétrolier", type: "text", },
  { id: "fuelType", label: "Type Carburant", type: "text", },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
];

export const INITIAL_TINKER_TYPE_DATA: ITankerType = {
  id: "",
  typeTanker : "",
  type : "",
  isActive: true,
  observation:""
};
