import type { TableColumn } from "@/shared/types/common";
import { _petrolier } from "..";
import { IFuelHistory, ITankerType, ITypeCarburant } from '@/shared/types/flottes/fuelImport';

export const _fuelHistories: IFuelHistory[] = [...Array(30)].map((_, i) => {
  const id = `${(i + 1).toString().padStart(6, "0")}`;
  const registrationDate = new Date(2025, Math.floor(i / 6), 3 + (i % 28)).toISOString().split("T")[0];

  return {
    id,
    providerType: _petrolier[i % _petrolier.length],
    registrationDate,
    kilometer: (Math.floor(Math.random() * 50000) + 1000).toString(),
    isActive: Math.random() < 0.8,
  };
});

export const DEFAULT_FUELHISTORY_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "providerType", label: "Pétrolier", type: "text" },
  { id: "registrationDate", label: "Date immatriculation", type: "date" },
  { id: "kilometer", label: "Kilomètre", type: "text" },
  { id: "", label: "Action" },
];
export const DEFAULT_FUEL_CARD_TABLE_HEAD: TableColumn[] = [
  { id: "__select", label: "", type: "checkbox" }, // ✅ colonne vide pour la case à cocher
  { id: "id", label: "N°", type: "text" },
  { id: "providerType", label: "Pétrolier", type: "text" },
  { id: "registrationDate", label: "Date immatriculation", type: "date" },
  { id: "kilometer", label: "Kilomètre", type: "text" },
  { id: 'isActive', label: 'Active', type: 'boolean' },
  { id: "", label: "Action" },
];

export const INITIAL_FUELHISTORY_DATA: IFuelHistory = {
  id: "",
  providerType: "",
  registrationDate: "",
  kilometer: "",
  supplierFile:"",
  isActive: true,
};

// NEW ADDITIONS - Type Carburant Management
export const TANKER_TYPES_MOCK: ITankerType[] = [
  {
    id: "1",
    typeTanker: "PETROLE SA",
    type: "Premium",
    isActive: true,
    observation: "Fournisseur principal"
  },
  {
    id: "2", 
    typeTanker: "SHELL France",
    type: "Standard",
    isActive: true,
    observation: "Réseau national"
  },
];

export const TYPE_CARBURANT_MOCK: ITypeCarburant[] = [
  {
    id: "1",
    numero: "TC001",
    nomType: "Diesel",
    statut: true,
    isActive: true,
    dateCreation: "2025-01-01",
    observation: "Carburant diesel standard"
  },
  {
    id: "2",
    numero: "TC002", 
    nomType: "Essence",
    statut: true,
    isActive: true,
    dateCreation: "2025-01-01",
    observation: "Essence sans plomb 95"
  },
  {
    id: "3",
    numero: "TC003",
    nomType: "Électrique",
    statut: true,
    isActive: true,
    dateCreation: "2025-01-02",
    observation: "Rechargement électrique"
  },
  {
    id: "4",
    numero: "TC004",
    nomType: "Hybride",
    statut: true,
    isActive: true,
    dateCreation: "2025-01-02",
    observation: "Véhicule hybride"
  },
  {
    id: "5",
    numero: "TC005",
    nomType: "GPL",
    statut: false,
    isActive: false,
    dateCreation: "2025-01-03",
    observation: "Gaz de pétrole liquéfié - En test"
  },
  {
    id: "6",
    numero: "TC006",
    nomType: "Biodiesel",
    statut: true,
    isActive: true,
    dateCreation: "2025-01-03",
    observation: "Carburant écologique"
  },
  {
    id: "7",
    numero: "TC007",
    nomType: "Ethanol",
    statut: false,
    isActive: true,
    dateCreation: "2025-01-04",
    observation: "E85 - Temporairement désactivé"
  }
];

export const TYPE_CARBURANT_TABLE_HEAD: TableColumn[] = [
  { id: "numero", label: "N°", type: "text" },
  { id: "nomType", label: "Nom du type", type: "text" },
  { id: "statut", label: "Statut", type: "boolean" },
  { id: "actions", label: "Actions", type: "text" },
];

export const DEFAULT_SUPPLIER_TYPE_TABLE_HEAD: TableColumn[] = [
  { id: "typeTanker", label: "Pétrolier", type: "text" },
  { id: "type", label: "Type Carburant", type: "text" },
  { id: "", label: "Action" },
];
