import type { TableColumn } from "@/shared/types/common"
import { InterventionTab, type IIntervention } from "@/shared/types/flottes/intervention"
import { _interventions } from "./_supplier"
import { InterventionType } from "@/shared/types/flottes/vehicule"
import { IMMATRICULATIONS } from ".."

export const _STATUTS = ["Réparation en cours", "En attente", "Terminé", "Annulé", "Planifié"]
export const _OBSERVATIONS = [
  "Glace verte",
  "Ampoules",
  "Freins",
  "Moteur",
  "Transmission",
  "Batterie",
  "Climatisation",
]
export const _REPARATEURS = ["Jean Jacques", "Marie Dupont", "Pierre Martin", "Sophie Leroy", "Thomas Dubois"]
export const _FOURNISSEURS = ["AutoPlus", "TurboParts", "MecaPro"]

export const _GARAGES = [
  "Garage Central", "Garage Sud", "Garage Nord", "Garage Est", "Garage Ouest"
];

export const _SECTEURS = [
  "Zone Industrielle", "Centre Ville", "Périphérie", "Quartier Est", "Quartier Ouest"
];

export const _IMMATRICULATIONS = [
  "AA-123-AA", "BB-456-BB", "CC-789-CC", "DD-101-DD", "EE-202-EE"
];

export const _DEPARTEMENTS = [
  "75 - Paris", "13 - Bouches-du-Rhône", "69 - Rhône", "33 - Gironde", "59 - Nord"
];

export const _OPTION_STATUT = [
  { value: InterventionTab.EnCours, label: "Réparation en cours" },
  { value: InterventionTab.EnAttente, label: "En attente" },
  { value: InterventionTab.Cloture, label: "Cloture" },
]
export const reparations = _interventions.filter(
  (intervention) => intervention.typeIntervention === InterventionType.Réparation
);

export const _REPAIRS: IIntervention[] = [...Array(20)].map((_, i) => {
  const numeroDossier = `${(i + 1).toString().padStart(7, "0")}`
  const dateIntervention = new Date(2025, Math.floor(i / 10), 15 + (i % 28)).toISOString().split("T")[0]
  const dateDebutImmo = dateIntervention
  const dateFinImmo = new Date(2025, Math.floor(i / 10), 15 + (i % 28) + 1 + Math.floor(Math.random() * 5))
    .toISOString()
    .split("T")[0]

  const kilometrage = `${160 + Math.floor(Math.random() * 40)}`

  return {
    id: numeroDossier,
    vehiculeConcerne: IMMATRICULATIONS[i % IMMATRICULATIONS.length],
    typeIntervention: InterventionType.Réparation,
    intervention: reparations[i % reparations.length].nomIntervention,
    dateIntervention: dateIntervention,
    statut: _OPTION_STATUT[i % 3].value,
    kilometrageReleve: kilometrage,
    montantDevis: `${i} 000 000`,
    coutHT: `${i}00`,
    coutTTC: `${i-10}00`,
    acceptationDevis: "Oui",
    observations: _OBSERVATIONS[i % _OBSERVATIONS.length],
    dateDebutImmobilisation: dateDebutImmo,
    dateFinImmobilisation: dateFinImmo,
    reparateur: _REPARATEURS[i % _REPARATEURS.length],
    factureRecue: "Oui",
    conducteurPrevenu: "Oui",
    fournisseur: _FOURNISSEURS[i % _FOURNISSEURS.length],
    isActive:Math.random() < 0.6,
    client: "",
    garage: _GARAGES[i % _GARAGES.length],
    secteur: _SECTEURS[i % _SECTEURS.length],
    immatriculation: _IMMATRICULATIONS[i % _IMMATRICULATIONS.length],
    departement: _DEPARTEMENTS[i % _DEPARTEMENTS.length],
    dateFacture: "",
    numeroFacture: "",
    pieces: "",
    quantitePieces: 0,
  }
})

export const _REPAIRS_DOCUMENT_TYPES = [
  { value: "facture", label: "Facture : Facture du garage/fournisseur" },
  { value: "devis", label: "Devis : Estimation des coûts" },
  { value: "photos", label: "Photos avant/après : Documentation visuelle" },
  { value: "rapport_technique", label: "Rapport technique : Diagnostic et intervention" },
  { value: "bon_sortie", label: "Bon de sortie : Bon de sortie du véhicule" },
  { value: "garantie", label: "Garantie : Certificats de garantie des pièces" },
];

export const DEFAULT_REPAIRS_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "vehiculeConcerne", label: "Véhicule", type: "text" },
  { id: "typeIntervention", label: "Intervention ", type: "text" },
  { id: "garage", label: "Garage", type: "text", align: "center" },
  { id: "secteur", label: "Secteur", type: "text", align: "center" },
  { id: "departement", label: "Département", type: "text", align: "center" },
  { id: "dateIntervention", label: "Date", type: "date" },
  { id: "statut", label: "Statut", isNotSortable: true },
  { id: "coutTTC", label: "Coût TTC", type: "text" },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: "", label: "Action" },
]

export const INITIAL_REPAIRS_DATA: IIntervention = {
  id: "",
  vehiculeConcerne: "",
  typeIntervention: InterventionType.Réparation,
  intervention: "",
  dateIntervention: "",
  statut: InterventionTab.EnAttente,
  kilometrageReleve: "",
  montantDevis: "",
  acceptationDevis: "",
  coutTTC: "",
  coutHT: "",
  observations: "",
  garage: "",
  immatriculation: "",
  departement: "",
  dateFacture: "",
  numeroFacture: "",
  pieces: "",
  quantitePieces: 0,
  dateDebutImmobilisation: "",
  dateFinImmobilisation: "",
  reparateur: "",
  factureRecue: "",
  conducteurPrevenu: "",
  fournisseur: "",
  isActive: true,
}