import type { TableColumn } from "@/shared/types/common";
import { ISuiviCarte, TypeCarburant, PetrolierType, IFuelCardImportHistory } from "@/shared/types/flottes/suiviCartes";

const conducteurs = [
  "Jean Dupont",
  "Marie Martin", 
  "Pierre Durand",
  "Sophie Leblanc",
  "Michel Bernard",
  "Claire Dubois",
  "David Moreau",
  "Sandrine Laurent"
];

const typeCarburants = [
  TypeCarburant.Diesel,
  TypeCarburant.Essence,
  TypeCarburant.Electrique,
  TypeCarburant.Hybride
];

const petroliers = [
  PetrolierType.DKV,
  PetrolierType.TOTAL,
  PetrolierType.SHELL,
  PetrolierType.BP,
  PetrolierType.ESSO
];

const adresses = [
  "Station Total - 123 Avenue de la République, Paris",
  "Shell Express - 45 Rue du Commerce, Lyon", 
  "DKV Station - 67 Boulevard des Invalides, Marseille",
  "BP Connect - 89 Route Nationale, Lille",
  "Esso Express - 12 Place de la Gare, Toulouse",
  "Total Access - 34 Avenue Jean Jaurès, Nice",
  "Shell - 56 Rue de la Paix, Strasbourg",
  "DKV - 78 Boulevard Voltaire, Bordeaux"
];

export const _suiviCartes: ISuiviCarte[] = [...Array(50)].map((_, i) => {
  const id = `${(i + 1).toString().padStart(6, "0")}`;
  const dateTransaction = new Date(2025, Math.floor(Math.random() * 3), Math.floor(Math.random() * 28) + 1).toISOString().split("T")[0];
  const quantite = Math.floor(Math.random() * 80) + 20; // 20-100 litres
  const prixUnitaire = Math.random() * 0.5 + 1.4; // 1.4-1.9 €/L
  const montantTransaction = Math.round(quantite * prixUnitaire * 100) / 100;

  return {
    id,
    numeroCarteCarburant: id,
    nomConducteur: conducteurs[i % conducteurs.length],
    dateTransaction,
    petrolier: petroliers[i % petroliers.length],
    typeCarburant: typeCarburants[i % typeCarburants.length],
    montantTransaction,
    quantite,
    adresseTransaction: adresses[i % adresses.length],
    isActive: Math.random() < 0.9,
  };
});

export const DEFAULT_SUIVI_CARTES_TABLE_HEAD: TableColumn[] = [
  { id: "numeroCarteCarburant", label: "N° Carte", type: "text" },
  { id: "nomConducteur", label: "Conducteur", type: "text" },
  { id: "dateTransaction", label: "Date Transaction", type: "date" },
  { id: "petrolier", label: "Pétrolier", type: "text" },
  { id: "typeCarburant", label: "Type Carburant", type: "text" },
  { id: "montantTransaction", label: "Montant (€)", type: "number" },
  { id: "quantite", label: "Quantité (L)", type: "number" },
  { id: "adresseTransaction", label: "Adresse", type: "text" },
  
];

export const INITIAL_SUIVI_CARTE_DATA: ISuiviCarte = {
  id: "",
  numeroCarteCarburant: "",
  nomConducteur: "",
  dateTransaction: "",
  petrolier: "",
  typeCarburant: "",
  montantTransaction: 0,
  quantite: 0,
  adresseTransaction: "",
  isActive: true,
}; 


const statuses = ["Terminé", "Échoué", "En cours"];
const types = ["DKV", "Total", "Shell"];

const getPrefixByMonth = (month: number): string => {
  if (month === 8) return "dkv"; 
  if (month === 9) return "shell"; 
  if (month === 10) return "total"; 
  return "import"; 
};

export const _fuelCardImportHistory: IFuelCardImportHistory[] = [...Array(30)].map((_, i) => {
  const id = `${(i + 1).toString().padStart(6, "0")}`;

  const month = 8 + Math.floor(Math.random() * 3);
  const start = new Date(2025, month, Math.floor(Math.random() * 28) + 1);
  const end = new Date(start);
  end.setMinutes(start.getMinutes() + Math.floor(Math.random() * 20) + 2);

  const status = statuses[Math.floor(Math.random() * statuses.length)];

  const type =
    month === 8 ? "DKV" : month === 9 ? "Shell" : "Total";

  const prefix = getPrefixByMonth(month);
  const fileName = `${prefix}_import_${start.toISOString().split("T")[0]}.csv`;

  return {
    id,
    fileName,
    importStartDate: start.toISOString(),
    importEndDate: end.toISOString(),
    status,
    type,
  };
});

export const INITIAL_FUEL_CARD_IMPORT_HISTORY_DATA: IFuelCardImportHistory = {
  id: "",
  fileName: "",
  importStartDate: "",
  importEndDate: "",
  status: "",
  type: "",
};
export const FUEL_CARD_IMPORT_HISTORY_TABLE_HEAD: TableColumn[] = [
  { id: "fileName", label: "Nom du fichier ", type: "text" },
  { id: "importStartDate", label: "Date début de l'importation", type: "date" },
  { id: "importEndDate", label: "Date de fin de l'importation", type: "date" },
  { id: "status", label: "Status", type: "text" },
  { id: "type", label: "Type", type: "text" },
];