import type { TableColumn } from "@/shared/types/common";
import { ISupplierIntervention, ISupplierType, InterventionType, ZoneCouvertureType } from "@/shared/types/flottes/vehicule";

export const _interventions: ISupplierIntervention[] = [
  { id: '1', nomIntervention: 'Vidange', typeIntervention: InterventionType.Entretien },
  { id: '2', nomIntervention: 'Changement de pneus', typeIntervention: InterventionType.Réparation },
  { id: '3', nomIntervention: 'Révision moteur', typeIntervention: InterventionType.Autre, autreTypeIntervention: 'Révision complète moteur' },
  { id: '4', nomIntervention: 'Contrôle technique', typeIntervention: InterventionType.Entretien },
  { id: '5', nomIntervention: 'Remplacement de batterie', typeIntervention: InterventionType.Réparation },
  { id: '6', nomIntervention: 'Installation GPS', typeIntervention: InterventionType.Autre, autreTypeIntervention: 'Installation équipement' },
];


export const NOMS_FOURNISSEUR = [
  "Fournisseur Alpha", "Fournisseur Beta", "Fournisseur Gamma", "Fournisseur Delta"
];
const ZONES_COUVERTURE = [ZoneCouvertureType.National, ZoneCouvertureType.Local];

export const _suppliers = [...Array(10)].map((_, i) => ({
  id: `${i + 1}`,
  nomFournisseur: NOMS_FOURNISSEUR[i % NOMS_FOURNISSEUR.length],
  zoneCouverture: ZONES_COUVERTURE[i % ZONES_COUVERTURE.length],
  typeIntervention: _interventions[i % _interventions.length].typeIntervention,
  intervention: _interventions[i % _interventions.length].nomIntervention,
  prix: 500 + Math.floor(Math.random() * 2000),
  isActive: Math.random() < 0.7,
}));

export const DEFAULT_SUPPLIER_TABLE_HEAD : TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'nomFournisseur', label: 'Nom du fournisseur',type: 'text' },
  { id: 'zoneCouverture', label: 'Zone de couverture',type: 'text' },
  { id: 'typeIntervention', label: 'Type d\'intervention',type: 'text' },
  { id: 'intervention', label: 'Intervention',type: 'text' },
  { id: 'prix', label: 'Prix',type: 'number' },
  { id: 'action', label: 'Action', align: 'center' },
];

export const INITIAL_SUPPLIER_DATA: ISupplierType = {
  id: '',
  nomFournisseur: '',
  zoneCouverture: ZoneCouvertureType.National,
  typeIntervention: '',
  intervention: '',
  prix: 0,
  isActive: true,
};

export const INITIAL_SUPPLIER_INTERVENTION_DATA: ISupplierIntervention = {
  id: '',
  nomIntervention: '',
  typeIntervention: InterventionType.Entretien,
};

export const  DEFAULT_SUPPLIER_INTERVENTION_TABLE_HEAD : TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'nomIntervention', label: 'Nom de l\'intervention',type: 'text' },
  { id: 'typeIntervention', label: 'Type d\'intervention',type: 'text' },
  { id: 'action', label: 'Action', align: 'center' },
];
