const endpointPrefix = '/api/absence';
  
// endpoints/absence-service.ts
export const absenceEndpoints = {
  absence: {
    attendanceSheet: {
      searchAttendanceSheets: `${endpointPrefix}/attendance-sheet/search`,
      getAttendanceSheetById: (id: string) => `${endpointPrefix}/attendance-sheet/${id}`, 
      createAttendanceSheet: `${endpointPrefix}/attendance-sheet/add`, 
      updateAttendanceSheet: (id: string) => `${endpointPrefix}/attendance-sheet/update/${id}`, 
      toggleStatus: (id: string) => `${endpointPrefix}/attendance-sheet/${id}/toggle-status`, 
      exportAttendanceSheets: `${endpointPrefix}/attendance-sheet/export`, 
      updateStatus: (id: string, status: string) => `${endpointPrefix}/attendance-sheet/${id}/status?status=${status}`,
      updateAttendanceStatus: (attendanceSheetId: number) => `${endpointPrefix}/attendance-sheet/${attendanceSheetId}/multiple-update`, 
      exportAttendanceSheetPdf: (id: number) => `${endpointPrefix}/attendance-sheet/export/pdf/${id}`,
    },
},
    agent: {
        search: `${endpointPrefix}/agent-absences/search`,
        create: `${endpointPrefix}/createAgentAbsence`,
        update: (id: string) => `${endpointPrefix}/${id}`,
        statistics: (userId: string | number) => `${endpointPrefix}/statistique/${userId}`,
        exportAbsences: `${endpointPrefix}/export_absence`,
        downloadExport: `${endpointPrefix}/export`,
        history: (id: string) => `${endpointPrefix}/agent/${id}/history`
      },
      common: {
        search: `${endpointPrefix}/search`,
       }
    }
