
const BASE_URL = "/api/admin/doc-requests";

export const documentRequestEndpoints = {
  add: `${BASE_URL}/add`,
  getAll: `${BASE_URL}/all`,
  getAllForUser: (userUuid : string) => `${BASE_URL}/all/${userUuid}`,
  getById: (id: number) => `${BASE_URL}/${id}`,
  update:  (codeReq: string) => `${BASE_URL}/update/${codeReq}`,
  delete: (id: number) => `${BASE_URL}/delete/${id}`,
  activate: (codeReq: string) => `${BASE_URL}/${codeReq}/activate`,
  deactivate: (codeReq: string) => `${BASE_URL}/${codeReq}/deactivate`,
  approve: (codeReq: string) => `${BASE_URL}/${codeReq}/approve`,
  reject: (codeReq: string) => `${BASE_URL}/${codeReq}/reject`,
};

export default documentRequestEndpoints;
