const endpointPrefix = "/api/admin"

export const establishmentEndpoints = {
  getEstablishmentsPage: endpointPrefix + "/establishments/page",
  toggleActivation: (id: string, active: boolean) => endpointPrefix + `/establishments/toggle-activation/${id}?active=${active}`,
  getEstablishmentById: (id: string) => endpointPrefix + `/establishments/${id}`,
  getAllEstablishmentNamesAndIds: endpointPrefix + "/establishments/all-names-ids",
  searchWithSpecificInfo: endpointPrefix + "/establishments/specific-names-ids",
  createEstablishment: endpointPrefix + "/establishments",
  updateEstablishment: (id: string) => endpointPrefix + `/establishments/update/${id}`,
  startExportFiltredEstablishments: endpointPrefix + "/establishments/startCsvExport",
  existsEstablishmentByCode: endpointPrefix + `/establishments/existsByCode`,
  existsEstablishmentByUaiCode: endpointPrefix + `/establishments/existsByUaiCode`,
  getEstablishmentHoursById: (id: string) => endpointPrefix + `/establishments/${id}/hours`,
  updateEstablishmentHours: (id: string) => endpointPrefix + `/establishments/update/${id}/hours`,
  holidays: {
    exportExcelTemplate: endpointPrefix + `/holiday/export-excel-template`,
    importHolidaysExcel: endpointPrefix + `/holiday/import-holidays-excel`,
    createHolidayImport: endpointPrefix + `/holiday/create-holiday-import`,
    getHolidaysListByYear: (year: number) => endpointPrefix + `/holiday/list/year/${year}`,
    getHolidaysListByYearAndMonth: (year: number, month: number) => endpointPrefix + `/holiday/list/year/${year}/month/${month}`,
    getHolidayImportPage: endpointPrefix + `/holiday/page`,
    startCsvExportHolidays: endpointPrefix + `/holiday/start-csv-holidays-export`,
  }
};