const endpointPrefix = "/api/admin/infrastructure"

export const infrastructureEndpoints = {
    Sector: {
        getSectorNamesAndIds: endpointPrefix + "/sectors/all-names-ids",
        getSectorsPage: endpointPrefix + "/sectors/page",
        toggleSectorActivation: (sectorId: string, active: boolean) => endpointPrefix + `/sectors/toggle-activation/${sectorId}?active=${active}`,
        getSectorById: (sectorId: string) => endpointPrefix + `/sectors/${sectorId}`,
        createSector: endpointPrefix + "/sectors",
        updateSector: (sectorId: string) => endpointPrefix + `/sectors/update/${sectorId}`,
        startExportInfrastructureDataInExcel: endpointPrefix + `/sectors/start-infrastructure-export-excel`,
        exportInfrastructureDataInPdf: endpointPrefix + `/sectors/export/pdf`,
        existsSectorByName: endpointPrefix + `/sectors/existsByName`,
    },
    Agency: {
        getAgencyNamesAndIds: endpointPrefix + "/agencies/all-names-ids",
        getAgencyPage: endpointPrefix + "/agencies/page",
        toggleAgencyActivation: (agencyId: string, active: boolean) => endpointPrefix + `/agencies/toggle-activation/${agencyId}?active=${active}`,
        getAgencyById: (agencyId: string) => endpointPrefix + `/agencies/${agencyId}`,
        createAgency: endpointPrefix + "/agencies",
        updateAgency: (agencyId: string) => endpointPrefix + `/agencies/update/${agencyId}`,
        existsAgencyByName: endpointPrefix + `/agencies/existsByName`,
    },
    Department: {
        getDepartmentNamesAndIds: endpointPrefix + "/departments/all-names-ids",
        getDepartmentNamesAndIdsByAgencyId: (agencyId: number) => endpointPrefix + `/departments/all-names-ids-by-agencyId/${agencyId}`,
        getDepartmentPage: endpointPrefix + "/departments/page",
        toggleDepartmentActivation: (departmentId: string, active: boolean) => endpointPrefix + `/departments/toggle-activation/${departmentId}?active=${active}`,
        getDepartmentById: (departmentId: string) => endpointPrefix + `/departments/${departmentId}`,
        createDepartment: endpointPrefix + "/departments",
        updateDepartment: (departmentId: string) => endpointPrefix + `/departments/update/${departmentId}`,
        getDepartmentHexColorById: (departmentId: string) => endpointPrefix + `/departments/hexColorById/${departmentId}`,
        existsDepartmentByName: endpointPrefix + `/departments/existsByName`,
        existsDepartmentByCode: endpointPrefix + `/departments/existsByCode`,
        existsDepartmentByColor: endpointPrefix + `/departments/existsByHexColor`,
        getDepartmentHexColorByName: (departmentName: string) => endpointPrefix + `/departments/hexColorByName/${departmentName}`,
        getParentAgencyByDepartmentId: (departmentId: number) => endpointPrefix + `/departments/${departmentId}/agency-name-id`,
        getLotsByDepartmentId: (departmentId: number) => endpointPrefix + `/departments/${departmentId}/lots-number-id`,
        getDepartmentNameIdById: (departmentId: number) => endpointPrefix + `/departments/${departmentId}/department-name-id`,
        getAllDepartmentColors: endpointPrefix + `/departments/colors`,
    },
    Lot: {
        getLotNumbersAndIds: endpointPrefix + "/lots/all-numbers-ids",
        getLotPage: endpointPrefix + "/lots/page",
        toggleLotActivation: (lotId: string, active: boolean) => endpointPrefix + `/lots/toggle-activation/${lotId}?active=${active}`,
        getLotById: (lotId: string) => endpointPrefix + `/lots/${lotId}`,
        createLot: endpointPrefix + "/lots",
        updateLot: (lotId: string) => endpointPrefix + `/lots/update/${lotId}`,
        existsLotByNumber: endpointPrefix + `/lots/existsByNumber`,
    }
};