const endpointPrefix = '/api/circuit';
const endpointPrefixTripPoint = '/api/circuit/trip/point';
const endpointPrefixDocument = '/api/document/docs/circuit';
const endpointPrefixAmendmentPassenger = '/api/circuit/amendment-passenger';

export const circuitEndpoints = {
  circuit: {
    search: endpointPrefix + '/search',
    add: endpointPrefix + '/add',
    update: endpointPrefix + '/update',
    updateStatus: (id: string) => endpointPrefix + `/${id}/status`,
    toggleActive: (id: string) => endpointPrefix + `/${id}/toggle-active`,
    getByCode: (circuitCode: string) => endpointPrefix + `/${circuitCode}`,
    addPassengers: endpointPrefix + '/add-passengers',
    removePassengers: endpointPrefix + '/passenger-unassignment',
    autocomplete: endpointPrefix + '/autocomplete',
    searchWithSpecificInfoByCircuitCode: endpointPrefix + '/searchWithSpecificInfo',
    getCircuitColorByCircuitCode: (circuitCode: string) =>
      endpointPrefix + `/circuit-color?circuitCode=${circuitCode}`,
    export: endpointPrefix + '/export',
    getDriverCircuit: endpointPrefix + `/driver`,
    ammendment: {
      getPassengersOfCircuit: (circuitId: string) =>
        endpointPrefix + `/amendment/passengers/${circuitId}`,
      getAmendments: endpointPrefix + `/amendment`,
      export: endpointPrefix + `/amendment/export`,
    },
    amendmentPassenger: {
      isPassengerAttachedToAmendment: (passengerId: string) =>
        `${endpointPrefixAmendmentPassenger}/${passengerId}/attached-to-amendment`,
      getAllAmendmentsPassenger: endpointPrefix + '/amendment-passenger/search-amendments',
      getAmendmentPassengerById: (id: string) => endpointPrefix + `/amendment-passenger/${id}`,
      updateAmendmentPassenger: (id: string) =>
        endpointPrefix + `/amendment-passenger/update/${id}`,
      addAmendmentPassenger: endpointPrefix + '/amendment-passenger/add',
      getActiveOrFutureAmendmentsByPassengerId:
        endpointPrefix + '/amendment-passenger/active-or-future',
      getAmendmentByPassengerId: (passengerId: string) =>
        endpointPrefix + `/amendment-passenger/by-passengerId/${passengerId}`,
      getInitialAmendmentByPassengerId: (passengerId: string) =>
        endpointPrefix + `/amendment-passenger/${passengerId}/initial`,
      areTripsAlreadyGeneratedForAmendment: (passengerId: string) =>
        endpointPrefix + `/amendment-passenger/${passengerId}/no-trips-generated`,
    },
    tripDriverAssignment: {
      addForTrip: endpointPrefix + "/trip-driver-assignments/add-for-trip",
      addForCircuit: endpointPrefix + "/trip-driver-assignments/add-for-circuit",
      addForMultipleTrips: endpointPrefix +'/trip-driver-assignments/add-multiple-trips', 
      update: (id: string) => endpointPrefix + `/trip-driver-assignments/update/${id}`,
      search: endpointPrefix + '/trip-driver-assignments/search',
      getAssignmentDetails: (id: string) => endpointPrefix + `/trip-driver-assignments/${id}`,
      findBestDriverForTrip: endpointPrefix + "/trip-driver-assignments/find-best-driver-trip",
      findBestDriverForCircuit: endpointPrefix + "/trip-driver-assignments/find-best-driver-circuit",
      checkDriverAssignment: endpointPrefix + "/trip-driver-assignments/check-assignment",
      findBestDriverForMultipleTrips: endpointPrefix +'/trip-driver-assignments/find-best-driver-multiple-trips',
      searchDriversForMap: endpointPrefix + "/trip-driver-assignments/search-drivers-map", 
    },
    trip: {
      generateTrips: (circuitId: string) => endpointPrefix + `/trip/generate-trips/${circuitId}`,
      canGenerateTrips: (circuitId: string) =>
        endpointPrefix + `/trip/can-generate-trips/${circuitId}`,
      getTrips: (circuitId: string) => endpointPrefix + `/trip/trips/${circuitId}`,
      getPersonalizedTrips: (circuitId: string) => endpointPrefix + `/trip/trips/personalized/${circuitId}`,
      getAmendmentTrips: (amendmentCircuitId: string) =>
        endpointPrefix + `/trip/trips/amendment/${amendmentCircuitId}`,
      getTripDetails: (id: string) => endpointPrefix + `/trip/${id}`,
      getShortTrip: endpointPrefix + `/trip/short-trips`,
      getAllTrips: endpointPrefix + `/trip`,
      getTripsByCircuitAndSchedule: endpointPrefix + `/trip/trips-by-circuit-and-schedule`,
      recalculateTrip: (tripId: string) => endpointPrefix + `/trip/recalculator/${tripId}`,
      export: endpointPrefix + `/trip/export`,
      downloadExport: endpointPrefix + `/trip/export/download`,
    },
    tripPoint: {
      addPoint: endpointPrefixTripPoint + '/add-point',
      swapSequenceOrder: (tripId: string, firstTripPointId: string, secondTripPointId: string) =>
        endpointPrefixTripPoint +
        `/swap-sequence-order/${tripId}?firstTripPointId=${firstTripPointId}&secondTripPointId=${secondTripPointId}`,

        updateArrivalTime: (tripPointId: string, newArrivalTime: string) =>
        endpointPrefixTripPoint +
        `/update-arrival-time?tripPointId=${tripPointId}&newArrivalTime=${newArrivalTime}`,
    },
  },
  document: {
    upload: endpointPrefixDocument + '/upload',
    download: (documentId: number) =>
      endpointPrefixDocument + `/download-circuit?documentId=${documentId}`,
    getAll: (circuitId: string) => endpointPrefixDocument + `/get-documents/${circuitId}`,
    delete: (documentId: number) =>
      endpointPrefixDocument + `/delete-circuit?documentId=${documentId}`,
  },
};
