const endpointPrefix = "/api/document";

export const documentEndpoints = {
  Folder: {
    create: endpointPrefix + "/folders/create",
    rename: (folderId: number, newName: string, ownerUuid: string) =>
      `${endpointPrefix}/folders/rename/${folderId}?newName=${encodeURIComponent(newName)}&ownerUuid=${ownerUuid}`,
    delete: (folderId: number, ownerUuid: string) => `${endpointPrefix}/folders/delete/${folderId}?ownerUuid=${ownerUuid}`,
    getById: (folderId: number) => `${endpointPrefix}/folders/${folderId}`,
    getUserRootFolders: (ownerUuid: string) => `${endpointPrefix}/folders/root/${ownerUuid}`,
    getUserAllFolders: (ownerUuid: string) => `${endpointPrefix}/folders/all/${ownerUuid}`,
    move: endpointPrefix + "/folders/move",
    bulkMove: endpointPrefix + "/folders/bulk/move",
    bulkDelete: endpointPrefix + "/folders/bulk/delete",
    bulkShare: endpointPrefix + "/folders/bulk/share",
    share: endpointPrefix + "/folders/share",
    favorite: (folderId: number, ownerUuid: string) => `${endpointPrefix}/folders/favorite/${folderId}?ownerUuid=${ownerUuid}`,
    unfavorite: (folderId: number, ownerUuid: string) => `${endpointPrefix}/folders/cancel-favorite/${folderId}?ownerUuid=${ownerUuid}`,
    getFavorites: (ownerUuid: string) => `${endpointPrefix}/folders/favorites/${ownerUuid}`,
    search: endpointPrefix + "/folders/search",
    advancedSearch: endpointPrefix + "/folders/advanced-search",
    getDetails: (folderId: number, ownerUuid:string) => `/api/document/folders/details/${folderId}?ownerUuid=${ownerUuid}`,
    downloadZip: (folderId: number, ownerUuid : string) => `${endpointPrefix}/folders/download?folderId=${folderId}&ownerUuid=${ownerUuid}`,
  },

  Document: {
    upload: endpointPrefix + "/docs/upload",
    getByIdAbDriver: (docId: number, ownerId: string) => `${endpointPrefix}/docs/details?documentId=${docId}&ownerUuid=${ownerId}`,
    getUserDocuments: (ownerUuid: string) => `${endpointPrefix}/docs/all?ownerUuid=${ownerUuid}`,
    delete: (ownerId: number, docId: number) => `${endpointPrefix}/docs/delete?ownerUuid=${ownerId}&documentId=${docId}`,
    renameDocument: (ownerId: string, docId: number, newName: string) => `${endpointPrefix}/docs/rename?ownerUuid=${ownerId}&documentId=${docId}&newName=${encodeURIComponent(newName)}`,
  },

  UserDocument: {
    upload: endpointPrefix + "/docs/upload",

    getAll: (ownerUuid: string | null) => `${endpointPrefix}/docs/all?ownerUuid=${ownerUuid}`,
    getDetails: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/details?documentId=${documentId}&ownerUuid=${ownerUuid}`,
    getRoot: (ownerUuid: string) => `${endpointPrefix}/docs/root?ownerUuid=${ownerUuid}`,
    statistics: (ownerUuid: string) => `${endpointPrefix}/docs/stats?ownerUuid=${ownerUuid}`,

    search: (ownerUuid: string, keyword?: string, sortBy = "name", asc = true) =>
      `${endpointPrefix}/docs/search?ownerUuid=${ownerUuid}&keyword=${keyword || ""}&sortBy=${sortBy}&asc=${asc}`,

    advancedSearch: endpointPrefix + "/docs/search-advanced",

    getDownloadUrl: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/get-download-url?documentId=${documentId}&ownerUuid=${ownerUuid}`,

    download: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/download?documentId=${documentId}&ownerUuid=${ownerUuid}`,

    delete: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/delete?documentId=${documentId}&ownerUuid=${ownerUuid}`,

    bulkDelete: endpointPrefix + "/docs/bulk-delete",

    share: (documentId: number, targetUserUuid: string) =>
      `${endpointPrefix}/docs/share?documentId=${documentId}&targetUserUuid=${targetUserUuid}`,

    bulkShare: endpointPrefix + "/docs/bulk-share",

    markFavorite: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/favorite/${documentId}?ownerUuid=${ownerUuid}`,

    unmarkFavorite: (documentId: number, ownerUuid: string) =>
      `${endpointPrefix}/docs/cancel-favorite/${documentId}?ownerUuid=${ownerUuid}`,

    favorites: (ownerUuid: string) => `${endpointPrefix}/docs/favorites?ownerUuid=${ownerUuid}`,

    move: (documentId: number, ownerUuid: string, folderId?: number) =>
      `${endpointPrefix}/docs/move/${documentId}?ownerUuid=${ownerUuid}` +
      (folderId ? `&folderId=${folderId}` : ""),

    bulkMove: endpointPrefix + "/docs/bulk-move",

    rename: (documentId: number, newName: string, ownerUuid: string) =>
      `${endpointPrefix}/docs/rename?documentId=${documentId}&newName=${encodeURIComponent(newName)}&ownerUuid=${ownerUuid}`,
  },

  Storage: {
    getQuotaInfo: (ownerUuid: string) => `${endpointPrefix}/storage/quota/${ownerUuid}`,
    isQuotaExceeded: (ownerUuid: string) => `${endpointPrefix}/storage/quota-exceeded/${ownerUuid}`,
    getUsed: (ownerUuid: string) => `${endpointPrefix}/storage/used/${ownerUuid}`,
    getAvailable: (ownerUuid: string) => `${endpointPrefix}/storage/available/${ownerUuid}`
  }
};
