
const prefix = '/api/fleet/fuel-supplier';

export const FuelSupplierEndpoints = {
  CREATE: `${prefix}/create`,
  UPDATE: (id: number) => `${prefix}/update/${id}`,
  DELETE: (id: number) => `${prefix}/delete/${id}`,
  GET_ALL: `${prefix}/all`,
  GET_BY_ID: (id: number) => `${prefix}/${id}`,
  GET_PAGE: `${prefix}/page`,
  GET_BY_FUEL_TYPE: `${prefix}/by-fuel-type`,
  TOGGLE_ACTIVE: (id: number) => `${prefix}/${id}/active`,
  START_EXPORT: (userId: number) => `${prefix}/start-export?userId=${userId}`, 
  DOWNLOAD_EXPORT: `${prefix}/download-export` 
};
