const endpointPrefix = "/api/fleet/fuel-type";

export const fuelTypeEndpoints = {
  getFuelTypesPage: endpointPrefix + "/page",
  getAllFuelTypes: endpointPrefix + "/all",
  getFuelTypeById: (id: number | string) => `${endpointPrefix}/${id}`,
  createFuelType: endpointPrefix,
  updateFuelType: (id: number | string) => `${endpointPrefix}/${id}`,
  toggleFuelTypeActive: (id: number | string) => `${endpointPrefix}/${id}/active`,
  startCsvExportFiltredFuelTypes: endpointPrefix + "/start-csv-export",
  existsFuelTypeByName: endpointPrefix + `/existsByName`,
};