const endpointPrefix = "/api/fleet/intervention";

export const interventionEndpoints = {
  getInterventionsPage: endpointPrefix + "/page",
  getAllInterventions: endpointPrefix + "/all",
  getInterventionById: (id: number | string) => `${endpointPrefix}/${id}`,
  createIntervention: endpointPrefix,
  updateIntervention: (id: number | string) => `${endpointPrefix}/${id}`,
  existsByName: `${endpointPrefix}/existsByName`,
  startCsvExportFiltredInterventions: endpointPrefix + "/start-csv-export",
  downloadCsvExport: (filePath: string) => `${endpointPrefix}/download-csv-export?filePath=${encodeURIComponent(filePath)}`,
};