const endpointPrefix = "/api/fleet/service-provider";

export const serviceProviderEndpoints = {
  getServiceProvidersPage: endpointPrefix + "/page",
  getAllServiceProviders: endpointPrefix + "/all",
  getServiceProviderById: (id: number | string) => `${endpointPrefix}/${id}`,
  createServiceProvider: endpointPrefix,
  updateServiceProvider: (id: number | string) => `${endpointPrefix}/${id}`,
  toggleActive: (id: number | string) => `${endpointPrefix}/${id}/active`,
  existsByName: `${endpointPrefix}/existsByName`,
  startCsvExportFiltredServiceProviders: endpointPrefix + "/start-csv-export",
  downloadCsvExport: `${endpointPrefix}/download-csv-export`,
};