const fleetPrefix = "/api/fleet/brand-model";

export const vehicleBrandModelEndpoints = {
    getPage: fleetPrefix + '/page',
    getById: (id: string) => fleetPrefix + `/${id}`,
    create: fleetPrefix,
    update: (id: string) => fleetPrefix + `/${id}`,
    toggleActive: (id: string) => fleetPrefix + `/${id}/active`,
    getBrands: fleetPrefix + '/brands',
    getModels: fleetPrefix + '/models',
    getModelsByBrand: (brandName: string) => fleetPrefix + `/models/${brandName}`,
    startCsvExport: fleetPrefix + '/start-csv-export',
    downloadCsvExport: fleetPrefix + '/download-csv-export',
    existsByBrandNameAndModelName: fleetPrefix + '/existsByBrandNameAndModelName',
    getVehicleTypeByBrandModel: fleetPrefix + '/vehicle-type-by-brand-model'
};