const fleetPrefix = "/api/fleet/vehicle";

export const vehicleEndpoints = {
    getPage: fleetPrefix + '/page',
    getById: (id: string) => fleetPrefix + `/${id}`,
    create: fleetPrefix,
    update: (id: string) => fleetPrefix + `/${id}`,
    toggleActive: (id: string) => fleetPrefix + `/${id}/active`,
    toggleStatus: (id: string) => fleetPrefix + `/${id}/status`,
    getShortAll: fleetPrefix + '/shorts',
    getShortByBrand: (brandName: string) => fleetPrefix + `/short/byBrand/${brandName}`,
    getShortByBrandModel: (brandName: string, modelName: string) => fleetPrefix + `/short/byBrand/${brandName}/byModel/${modelName}`,
    getShortByType: (vehicleType: string) => fleetPrefix + `/short/byType/${vehicleType}`,
    existsByVehicleIdentificationNumber: fleetPrefix + `/existsByVehicleIdentificationNumber`,
    existsByRegistrationPlate: fleetPrefix + `/existsByRegistrationPlate`,
    startCsvExport: fleetPrefix + '/start-csv-export',
    downloadCsvExport: fleetPrefix + '/download-csv-export',
};