const API_BASE = "/api/fleet/repairs"

export const vehicleRepairEndpoints = {
  getPage: API_BASE,
  getById: (id: string) => `${API_BASE}/${id}`,
  create: API_BASE,
  update: (id: string) => `${API_BASE}/${id}`,
  setStatus: (id: string) => `${API_BASE}/${id}/status`,
  acceptQuote: (id: string) => `${API_BASE}/${id}/accept-quote`,
  recordCosts: (id: string) => `${API_BASE}/${id}/costs`,
  setImmobilization: (id: string) => `${API_BASE}/${id}/immobilization`,
  toggleActive: (id: string) => `${API_BASE}/${id}/active`,
  delete: (id: string) => `${API_BASE}/${id}`,
  getOpenByVehicle: (vehicleId: string) => `${API_BASE}/vehicle/${vehicleId}/open`,
  startCsvExport: `${API_BASE}/start-csv-export`,
  downloadCsvExport: `${API_BASE}/download-csv-export`,
}
