
const FLEET_DOCS_BASE = '/api/document/fleet/documents';
const FLEET_FOLDERS_BASE = '/api/document/fleet/folders';

export const fleetDocumentEndpoints = {
  
  
  upload: `${FLEET_DOCS_BASE}/upload`,


  root: `${FLEET_DOCS_BASE}/root`,

  
  all: `${FLEET_DOCS_BASE}/all`,

      folder: (folderId: number) => `${FLEET_DOCS_BASE}/folder/${folderId}`,

  download: `${FLEET_DOCS_BASE}/download`,

    
  bulkDelete: `${FLEET_DOCS_BASE}/bulk-delete`,

  
  rename: `${FLEET_DOCS_BASE}/rename`,
};

export const fleetFolderEndpoints = {
  
  create: `${FLEET_FOLDERS_BASE}/create`,

  root: `${FLEET_FOLDERS_BASE}/root`,

  subfolders: (parentId: number) => `${FLEET_FOLDERS_BASE}/subfolders/${parentId}`,

  download: (folderId: number) => `${FLEET_FOLDERS_BASE}/download/${folderId}`,

  bulkDelete: `${FLEET_FOLDERS_BASE}/bulk-delete`,

  rename: (folderId: number) => `${FLEET_FOLDERS_BASE}/rename/${folderId}`,
};





