const FLEET_DOCS_BASE = '/api/document/fleet/documents';
const FLEET_FOLDERS_BASE = '/api/document/fleet/folders';

export const fleetDocumentEndpoints = {
  upload: `${FLEET_DOCS_BASE}/upload`,

  all: `${FLEET_DOCS_BASE}/all`,
  root: `${FLEET_DOCS_BASE}/root`,
  details: `${FLEET_DOCS_BASE}/details`,
  folder: (folderId: number) => `${FLEET_DOCS_BASE}/folder/${folderId}`,

  statistics: `${FLEET_DOCS_BASE}/statistics`,

  downloadUrl: `${FLEET_DOCS_BASE}/download-url`,
  download: `${FLEET_DOCS_BASE}/download`,
  getDownloadLink: (documentId: string | number) => `${FLEET_DOCS_BASE}/download-link/${documentId}`,

  search: `${FLEET_DOCS_BASE}/search`,
  advancedSearch: `${FLEET_DOCS_BASE}/search/advanced`,

  delete: `${FLEET_DOCS_BASE}/delete`,
  bulkDelete: `${FLEET_DOCS_BASE}/bulk-delete`,

  favorite: (documentId: number) => `${FLEET_DOCS_BASE}/${documentId}/favorite`,
  favorites: `${FLEET_DOCS_BASE}/favorites`,

  move: (documentId: number) => `${FLEET_DOCS_BASE}/${documentId}/move`,
  bulkMove: `${FLEET_DOCS_BASE}/bulk-move`,

  rename: `${FLEET_DOCS_BASE}/rename`,
};

export const fleetFolderEndpoints = {
  create: `${FLEET_FOLDERS_BASE}/create`,

  root: `${FLEET_FOLDERS_BASE}/root`,
  subfolders: (folderId: number) => `${FLEET_FOLDERS_BASE}/subfolders/${folderId}`, 
  documents: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}/documents`,
  details: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}/details`,

  rename: (folderId: number) => `${FLEET_FOLDERS_BASE}/rename/${folderId}`, 
  move: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}/move`,

  delete: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}`,
  bulkDelete: `${FLEET_FOLDERS_BASE}/bulk-delete`,

  download: (folderId: number) => `${FLEET_FOLDERS_BASE}/download/${folderId}`,

  search: `${FLEET_FOLDERS_BASE}/search`,

  favorite: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}/favorite`,
  unfavorite: (folderId: number) => `${FLEET_FOLDERS_BASE}/${folderId}/favorite`,
  favorites: `${FLEET_FOLDERS_BASE}/favorites`,
};
