const endpointPrefix = "/api/hr/annual-appointments";

export const appointmentEndpoints = {
  search: endpointPrefix + "/search",
  details: (id: string | number) => `${endpointPrefix}/${id}`,
  create: endpointPrefix + "/add",
  update: (id: string | number) => `${endpointPrefix}/${id}`,
  delete: (id: string | number) => `${endpointPrefix}/${id}`,
  cancel: (id: string | number) => `${endpointPrefix}/${id}/cancel`,
  export: endpointPrefix + "/export",
  calendarDay: (date: string) => `${endpointPrefix}/calendar/day/${date}`,
  calendarWeek: (startDate: string) => `${endpointPrefix}/calendar/week/${startDate}`,
  calendarMonth: (year: number, month: number) => `${endpointPrefix}/calendar/month/${year}/${month}`,
};
