import axiosInstance from '@/utils/axios';
import type { ContractGenerationRequest, ContractGenerationResponse } from '@/shared/types/contract';

const endpointPrefix = '/api/hr/contracts';

export const contractsEndpoints = {
  base: endpointPrefix,
  generate: `${endpointPrefix}/generate`,
  download: (contractId: string) => `${endpointPrefix}/download/${contractId}`,
  sendToDocuSign: `${endpointPrefix}/send-to-docusign`,
  status: (contractId: string) => `${endpointPrefix}/status/${contractId}`,
};

export const contractsApi = {
  // Generate contract for an employee
  generateContract: async (request: ContractGenerationRequest): Promise<{ data: ContractGenerationResponse }> => {
    const response = await axiosInstance.post(contractsEndpoints.generate, request);
    return response;
  },

  // Download generated contract
  downloadContract: async (contractId: string): Promise<Blob> => {
    const response = await axiosInstance.get(contractsEndpoints.download(contractId), {
      responseType: 'blob',
    });
    return response.data;
  },

  // Send contract to DocuSign
  sendToDocuSign: async (request: ContractGenerationRequest): Promise<{ data: ContractGenerationResponse }> => {
    const response = await axiosInstance.post(contractsEndpoints.sendToDocuSign, request);
    return response;
  },

  // Get contract status
  getContractStatus: async (contractId: string): Promise<{ data: ContractGenerationResponse }> => {
    const response = await axiosInstance.get(contractsEndpoints.status(contractId));
    return response;
  },
};
