import axiosInstance from '@/utils/axios';

const exportEndpoints = {
  start: '/api/hr/employees/export/start',
  download: '/api/hr/employees/export/download',
  status: '/api/hr/employees/export/status',
};

export interface ExportEmployeesRequest {
  employeeIds?: number[];
  statuses?: string[];
  types?: string[];
  departments?: string[];
  createdDateFrom?: string;
  createdDateTo?: string;
  userId?: number;
}

export const employeeExportApi = {
  // Start export with filters
  startExport: async (request: ExportEmployeesRequest): Promise<{ data: string }> => {
    const response = await axiosInstance.post(exportEndpoints.start, request);
    return response;
  },

  // Download exported file
  downloadExportFile: async (filePath: string): Promise<Blob> => {
    const response = await axiosInstance.get(exportEndpoints.download, {
      params: { filePath },
      responseType: 'blob',
    });
    return response.data;
  },

  // Check export status
  getExportStatus: async (filePath: string): Promise<{ data: string }> => {
    const response = await axiosInstance.get(exportEndpoints.status, {
      params: { filePath },
    });
    return response;
  },
};
