const endpointPrefix = "/api/hr/candidatures";

export const sedentaryCandidatureEndpoints = {
    getAllCandidatures: endpointPrefix + "/all",
    getCandidatureById: (id: number) => `${endpointPrefix}/${id}`,
    createCandidature: endpointPrefix + "/create",
    updateCandidature: (id: number) => `${endpointPrefix}/${id}`,
    deleteCandidature: (id: number) => `${endpointPrefix}/${id}/delete`,
    exportCandidature: (id: number) => `${endpointPrefix}/${id}/export`,
    getCandidaturesByStatus: (status: string) => `${endpointPrefix}/status/${status}`,
    sendEmail: endpointPrefix + "/send-email",
    sendEmailTemplate: endpointPrefix + "/send-email-template",
    sendForm: endpointPrefix + "/send-from",
};
