import axiosInstance from '@/utils/axios';
import type { TripShortDTO } from '@/shared/types/trip';
import type { Department } from './candidates';

const endpointPrefix = '/api/hr/trips';
const endpointPrefi = '/api/circuit/trip/trip';
export const tripsEndpoints = {
  base: endpointPrefix,
  shortTripsByDriver: `${endpointPrefi}/short-trips-by-driver`,
  departments: '/api/hr/departments',
};

export const tripsApi = {
  getShortTripsByDriver: async (driverId: number): Promise<{ data: TripShortDTO[] }> => {
    const response = await axiosInstance.get(tripsEndpoints.shortTripsByDriver, {
      params: { driverId },
    });
    return response;
  },

  getDepartments: async (): Promise<Department[]> => {
    const response = await axiosInstance.get(tripsEndpoints.departments);
    return response.data;
  },
};
