const endpointPrefix = "/api/planning/drivers"
const endpointPrefixTrip = '/api/planning';

export const planningDriverEndpoints = {
  dailySchedule: (date: string) => `${endpointPrefix}/trips/daily?date=${date}`,
  dailyNonAffected: (date: string) => `${endpointPrefix}/trips-NA/daily?date=${date}`,
  affectTrip: (planningId: string, targetDriverId: number) => `${endpointPrefix}/trip/affect?driverId=${targetDriverId}&tripCircuitId=${planningId}`,
  reAffectTrip: (planningId: string, targetDriverId: number) => `${endpointPrefix}/trip/reaffect?driverId=${targetDriverId}&tripCircuitId=${planningId}`,
  disAffectTrip: (planningId: string, targetDriverId: string) => `${endpointPrefix}/trip/disaffect?driverId=${targetDriverId}&tripPlanningId=${planningId}`,
  getAllDailyTrips: endpointPrefixTrip + `/trips/daily`, 

};