import { add } from 'date-fns';

const endpointPrefix = '/api/roadMap';
const geolocEndpointPrefix = '/api/geolocation';
const planningEndpointPrefix = '/api/planning';

export const roadMapEndpoints = {
  roadMap: {
    validaRoadMap: {
      getAllValidRoadmap: endpointPrefix + '/validatedRoadMaps',
      getValidRoadmap: endpointPrefix + '/validatedRoadMaps/{id}/details',
      updateValidRoadmapStatus: endpointPrefix + '/validate/{id}',
      add: endpointPrefix + '/validatedRoadMaps/add',
      getOldValidatedRoadmapDetails: (id: number) => `${endpointPrefix}/validatedRoadMaps/details/${id}`,

      getOldRoadmapByDriver: (id: number) => `${endpointPrefix}/validatedRoadMaps/driver/${id}`,
      getAllDelaValidRoadmap: endpointPrefix + '/validatedRoadMaps/deal',
      updateStatus: (id: number | string) => `${endpointPrefix}/${id}/status`,

      getGeolocData: geolocEndpointPrefix + '/hours?driverId={driverId}&year={year}&month={month}',
      getPlanningData: planningEndpointPrefix + '/drivers/monthly?driverId={driverId}&date={date}',
      getDriverRoadMap: endpointPrefix + '/driverRoadMap/driver/{driverId}?date={date}',
      getCombinedTable: endpointPrefix + '/combinedTable/drivers/{driverId}?date={date}',
      createUpdateDailyRoadMap:
        endpointPrefix +
        '/dailyRoadMap/validatedRoadMap/{validatedRoadMapId}/combinedTableDay/{combinedTableDayId}?date={date}',
    },
    submittedRoadMap: {
      getAllsubmittedRoadmap: endpointPrefix + '/submittedRoadMaps',
      getOldSubmittedRoadmaps: endpointPrefix + '/submittedRoadMaps/old',
      getOldSubmittedRoadmapDetails: (id: number) => `${endpointPrefix}/submittedRoadMaps/${id}`,
      create: `${endpointPrefix}/create`,
      updateStatus: (id: number | boolean) => `${endpointPrefix}/submittedRoadMaps/${id}/status`,
      getWorkedDaysDates: endpointPrefix + '/submittedRoadMaps/worked-days',
    },
    statistics: {
      getStatistics: `${endpointPrefix}/statistics`,
    },
  },
  workedDay: {
    getByDate: `${endpointPrefix}/workedDay/by-date`,
    createOrUpdate: `${endpointPrefix}/workedDay/create-or-update`,
    getDriverInfo: (id: number) => `${endpointPrefix}/driver/infos/${id}`,
  },
  planning: {
    schedulePlanning: `${endpointPrefix}/schedule`,
    getPlanningRequests: `${endpointPrefix}/planning-request`,
    getPlanningRequestDetails: (id: number) => `${endpointPrefix}/planning-request/details/${id}`
  },
};
