import { CollaboratorStatus } from "@/shared/types/client";
import { State } from "@/shared/types/passenger";
import { RoleStatus } from "../stores/roleStore";

const endpointPrefix = '/api/user';

export const userEndpoints = {
  user: {
    getAllUsers: endpointPrefix + "/all",
    existsUserByPersonalEmail: (personalEmail: string) => `${endpointPrefix}/exists-by-personalEmail/${personalEmail}`,
    client: {
      addClient: endpointPrefix + '/client/add',
      getAllClients: endpointPrefix + '/client/search',
      toggleActiveClient: (id: string) => `${endpointPrefix}/client/${id}/active`,
      getClientById: (id: string) => `/client/${id}`,
      updateClient: endpointPrefix + '/client/update',
      exportClients: endpointPrefix + '/client/export',
      getAllClientsBasicInfo: endpointPrefix + '/client/basic-info-list',
      getAllClientsDropdownList: endpointPrefix + '/client/clients-dropdown-list',
    },
     collaborator: {
      add: endpointPrefix + '/collaborators/add',
      update: endpointPrefix + '/collaborators/update',
      updateSkype: (id: string | number) => endpointPrefix + `/collaborators/${id}/skype`,
      updateContact: (id: string | number) => endpointPrefix + `/collaborators/${id}/contact`,
      toggleActive: (id: string | number) => endpointPrefix + `/collaborators/toggle-active/${id}`,
      search: endpointPrefix + '/collaborators/search',
      changeStatus: (id: string | number, status: CollaboratorStatus) =>
      endpointPrefix + `/collaborators/change-status?id=${id}&status=${status}`,
      exportFiltered:  endpointPrefix + '/collaborators/export',
      updatePassword: endpointPrefix + '/update-password',
      changePassword: endpointPrefix + '/change-password',
      sendResetPassword: endpointPrefix + '/send-reset-password',
      confirmOtp: endpointPrefix + '/confirm-otp',
      confirmPassword: endpointPrefix + '/confirm-password',
      getOtpByUsername: (username: string) => endpointPrefix + `/otp/${username}`,
      downloadExport: (filePath: string) =>  endpointPrefix +
        `/collaborators/download?filePath=${encodeURIComponent(filePath)}`,
      getAllCollaborators: endpointPrefix + '/collaborators/all',
      withoutTeam: endpointPrefix + '/collaborators/without-team',
      getCollaboratorById: (id: string | number) => endpointPrefix + `/collaborators/${id}`,
      autocomplete: endpointPrefix + '/collaborators/autocomplete',
      getByDepartment: (departmentId: string | number) => endpointPrefix + `/collaborators/department/${departmentId}`,
    },
    workStatus: {
      add: endpointPrefix + '/work-status/add',
      getToday: (id: string | number) => endpointPrefix + `/work-status/${id}/today`,
    },


    auth: {
      login: endpointPrefix + '/login',
      logout: endpointPrefix + '/logout',
      history: endpointPrefix + '/history',
    },
    clientType: {
      getAll: endpointPrefix + '/clientType/all',
    },
    Role: {
      listAllRoles: endpointPrefix + '/role',
      getAllRoles: '/api/user/role/all',
      createRole: '/api/user/role/add',
      updateRole: (id: string | number) => `/api/user/role/update/${id}`,
      changeStatus: (id: string | number, status: 'ENABLED' | 'DISABLED') =>
        `/api/user/role/${id}/status?status=${status}`,
      getPermissionsByRoleName: (roleName: string) => `/api/user/role/${roleName}/permissions`,
      startCsvExport: `/api/user/role`,
      downloadCsvExport:  `/api/user/role/download`,
    },
    passenger: {
      getAllPassengers: endpointPrefix + '/passenger/search',
      getPassengerById: (id: string) => endpointPrefix + `/passenger/${id}`,
      updatePassenger: endpointPrefix + '/passenger/update',
      addPassenger: endpointPrefix + '/passenger/add',
      toggleArchive: (id: string) => endpointPrefix + `/passenger/${id}/toggle-archive`,
      exportPassengers: endpointPrefix + '/passenger/export',
      getShortPassengers: endpointPrefix + '/passenger/search/short',
      updateStatus: (id : string, passengerState: State) => endpointPrefix + `/passenger/update-state?passengerId=${id}&newState=${passengerState}`,
      assignCircuitToRepresentatives: endpointPrefix + '/passenger/assign-circuit',
      cancelCircuitAssignmentForRepresentatives: endpointPrefix + '/passenger/representatives/cancel-circuit',
      searchPassengersWithNoCircuit: endpointPrefix + "/passenger/search-without-circuit",
      searchPassengerNames: endpointPrefix + '/passenger/search/names',
      importPassengers: endpointPrefix + '/passenger/import',
      downloadPassengersTemplate: endpointPrefix + '/passenger/download_import_tmpl',
      getPassengerDetails: endpointPrefix + `/passenger/details`,
    },
    team: {
      getAllTeams: endpointPrefix + "/teams/search",
      createTeam: endpointPrefix + "/teams/create",
      updateTeam: endpointPrefix + "/teams/update",
      duplicateTeam: endpointPrefix + "/teams/duplicate",
      getTeamById: (id: string) => `${endpointPrefix}/teams/${id}`,
      toggleStatus: (id: string) => `${endpointPrefix}/teams/${id}/toggle-status`,
      removeMember: (teamId: number, memberId: number) =>
        `${endpointPrefix}/teams/${teamId}/members/${memberId}/remove`,
      exportTeams: endpointPrefix + "/teams/export",
      findAllTeamIdAndName: endpointPrefix + '/teams/findAllTeamIdAndName',
    },

  },
};
